/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CommunicationProvider } from '@theia/debug/lib/node/debug-model';
import { DebugAdapterExecutable, DebugAdapterInlineImplementation, DebugAdapterNamedPipeServer, DebugAdapterServer } from '../../types-impl';
/**
 * Starts debug adapter process.
 */
export declare function startDebugAdapter(executable: DebugAdapterExecutable): CommunicationProvider;
/**
 * Connects to a remote debug server.
 */
export declare function connectSocketDebugAdapter(server: DebugAdapterServer): CommunicationProvider;
export declare function connectPipeDebugAdapter(adapter: DebugAdapterNamedPipeServer): CommunicationProvider;
export declare function connectInlineDebugAdapter(adapter: DebugAdapterInlineImplementation): CommunicationProvider;
//# sourceMappingURL=plugin-debug-adapter-starter.d.ts.map