/********************************************************************************
 * Copyright (C) 2021 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Plugin, SecretsExt } from '../common/plugin-api-rpc';
import { RPCProtocol } from '../common/rpc-protocol';
import { Event } from '@theia/core/lib/common/event';
import * as theia from '@theia/plugin';
export declare class SecretsExtImpl implements SecretsExt {
    private proxy;
    private onDidChangePasswordEmitter;
    readonly onDidChangePassword: Event<{
        extensionId: string;
        key: string;
    }>;
    constructor(rpc: RPCProtocol);
    $onDidChangePassword(e: {
        extensionId: string;
        key: string;
    }): Promise<void>;
    get(extensionId: string, key: string): Promise<string | undefined>;
    store(extensionId: string, key: string, value: string): Promise<void>;
    delete(extensionId: string, key: string): Promise<void>;
}
export declare class SecretStorageExt implements theia.SecretStorage {
    protected readonly id: string;
    readonly secretState: SecretsExtImpl;
    private onDidChangeEmitter;
    readonly onDidChange: Event<theia.SecretStorageChangeEvent>;
    constructor(pluginDescription: Plugin, secretState: SecretsExtImpl);
    get(key: string): Promise<string | undefined>;
    store(key: string, value: string): Promise<void>;
    delete(key: string): Promise<void>;
}
//# sourceMappingURL=secrets-ext.d.ts.map