/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { ColorTheme, ColorThemeKind } from './types-impl';
import { Event } from '@theia/core/lib/common/event';
import { ThemingExt } from '../common';
import { RPCProtocol } from '../common/rpc-protocol';
import { ThemeType } from '@theia/core/lib/browser/theming';
export declare class ThemingExtImpl implements ThemingExt {
    readonly rpc: RPCProtocol;
    private actual;
    private ondDidChangeActiveColorTheme;
    constructor(rpc: RPCProtocol);
    get activeColorTheme(): ColorTheme;
    $onColorThemeChange(type: ThemeType): void;
    protected convertKind(type: ThemeType): ColorThemeKind;
    get onDidChangeActiveColorTheme(): Event<ColorTheme>;
}
//# sourceMappingURL=theming.d.ts.map