/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="lodash" />
import { CompositeTreeNode, PreferenceSchemaProvider, PreferenceDataProperty } from '@theia/core/lib/browser';
import { PreferenceConfigurations } from '@theia/core/lib/browser/preferences/preference-configurations';
import { Emitter } from '@theia/core';
import { Preference } from './preference-types';
export declare const COMMONLY_USED_SECTION_PREFIX = "commonly-used";
export declare class PreferenceTreeGenerator {
    protected readonly schemaProvider: PreferenceSchemaProvider;
    protected readonly preferenceConfigs: PreferenceConfigurations;
    protected _root: CompositeTreeNode;
    protected readonly onSchemaChangedEmitter: Emitter<CompositeTreeNode>;
    readonly onSchemaChanged: import("@theia/core").Event<CompositeTreeNode>;
    protected readonly commonlyUsedPreferences: string[];
    protected readonly topLevelCategories: Map<string, string>;
    protected readonly sectionAssignments: Map<string, string>;
    protected readonly defaultTopLevelCategory = "extensions";
    get root(): CompositeTreeNode;
    protected init(): Promise<void>;
    generateTree(): CompositeTreeNode;
    protected getGroupName(labels: string[]): string;
    protected getSubgroupName(labels: string[], computedGroupName: string): string | undefined;
    doHandleChangedSchema(): void;
    handleChangedSchema: import("lodash").DebouncedFunc<() => void>;
    protected createRootNode(): CompositeTreeNode;
    protected createLeafNode(property: string, preferencesGroup: Preference.CompositeTreeNode, data: PreferenceDataProperty): Preference.LeafNode;
    protected createPreferencesGroup(id: string, group: string, root: CompositeTreeNode): Preference.CompositeTreeNode;
    getCustomLabelFor(id: string): string | undefined;
    protected getOrCreatePreferencesGroup(id: string, group: string, root: CompositeTreeNode, groups: Map<string, Preference.CompositeTreeNode>): Preference.CompositeTreeNode;
}
//# sourceMappingURL=preference-tree-generator.d.ts.map