/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { LabelProviderContribution } from '@theia/core/lib/browser';
import { Preference } from './preference-types';
import { PreferenceTreeGenerator } from './preference-tree-generator';
export declare class PreferenceTreeLabelProvider implements LabelProviderContribution {
    protected readonly treeGenerator: PreferenceTreeGenerator;
    canHandle(element: object): number;
    getName(node: Preference.TreeNode): string;
    getPrefix(node: Preference.TreeNode, fullPath?: boolean): string | undefined;
    protected formatString(string: string): string;
    protected isUpperCase(char: string): boolean;
}
//# sourceMappingURL=preference-tree-label-provider.d.ts.map