/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PreferenceDataProperty, TreeNode as BaseTreeNode, CompositeTreeNode as BaseCompositeTreeNode, PreferenceInspection } from '@theia/core/lib/browser';
import { Command, MenuPath } from '@theia/core';
import { JSONValue } from '@theia/core/shared/@phosphor/coreutils';
export declare namespace Preference {
    interface EditorCommandArgs {
        id: string;
        value: string | undefined;
    }
    namespace EditorCommandArgs {
        function is(prefObject: EditorCommandArgs): prefObject is EditorCommandArgs;
    }
    const Node: unique symbol;
    type Node = TreeNode;
    type TreeNode = CompositeTreeNode | LeafNode;
    namespace TreeNode {
        const is: (node: BaseTreeNode | TreeNode) => node is TreeNode;
        const isTopLevel: (node: BaseTreeNode) => boolean;
        const getGroupAndIdFromNodeId: (nodeId: string) => {
            group: string;
            id: string;
        };
    }
    interface CompositeTreeNode extends BaseCompositeTreeNode {
        depth: number;
    }
    interface LeafNode extends BaseTreeNode {
        depth: number;
        preference: {
            data: PreferenceDataProperty;
        };
    }
    namespace LeafNode {
        const is: (node: BaseTreeNode | LeafNode) => node is LeafNode;
    }
    const getValueInScope: <T extends JSONValue>(preferenceInfo: PreferenceInspection<T> | undefined, scope: number) => T | undefined;
    interface SelectedScopeDetails {
        scope: number;
        uri: string | undefined;
        activeScopeIsFolder: boolean;
    }
    const DEFAULT_SCOPE: SelectedScopeDetails;
    /**
     * @deprecated since 1.15.0 this type is no longer used.
     */
    interface ContextMenuCallbacks {
        resetCallback(): void;
        copyIDCallback(): void;
        copyJSONCallback(): void;
    }
}
export declare namespace PreferencesCommands {
    const OPEN_PREFERENCES_JSON_TOOLBAR: Command;
    const COPY_JSON_NAME: Command;
    const RESET_PREFERENCE: Command;
    const COPY_JSON_VALUE: Command;
    const OPEN_USER_PREFERENCES: Command;
    const OPEN_WORKSPACE_PREFERENCES: Command;
    const OPEN_FOLDER_PREFERENCES: Command;
    const OPEN_USER_PREFERENCES_JSON: Command;
    const OPEN_WORKSPACE_PREFERENCES_JSON: Command;
    const OPEN_FOLDER_PREFERENCES_JSON: Command;
}
export declare namespace PreferenceMenus {
    const PREFERENCE_EDITOR_CONTEXT_MENU: MenuPath;
    const PREFERENCE_EDITOR_COPY_ACTIONS: MenuPath;
    const FOLDER_SCOPE_MENU_PATH: string[];
}
//# sourceMappingURL=preference-types.d.ts.map