/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PreferenceLeafNodeRenderer } from './preference-node-renderer';
export declare class PreferenceArrayInputRenderer extends PreferenceLeafNodeRenderer<string[], HTMLInputElement> {
    existingValues: Map<string, {
        node: HTMLElement;
        index: number;
    }>;
    wrapper: HTMLElement;
    inputWrapper: HTMLElement;
    protected createInteractable(parent: HTMLElement): void;
    protected getFallbackValue(): string[];
    protected createExistingValue(value: string): HTMLElement;
    protected createInput(): HTMLElement;
    protected doHandleValueChange(): void;
    protected removeItem(value: string): void;
    protected handleEnter(e: KeyboardEvent): void;
    protected addItem(): void;
    protected getOrderedValues(): string[];
    dispose(): void;
}
//# sourceMappingURL=preference-array-input.d.ts.map