/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PreferenceLeafNodeRenderer } from './preference-node-renderer';
interface PreferenceNumberInputValidation {
    /**
     * the numeric value of the input. `NaN` if there is an error.
     */
    value: number;
    /**
     * the error message to display.
     */
    message: string;
}
export declare class PreferenceNumberInputRenderer extends PreferenceLeafNodeRenderer<number, HTMLInputElement> {
    protected _errorMessage: HTMLElement | undefined;
    protected interactableWrapper: HTMLElement;
    get errorMessage(): HTMLElement;
    protected createInteractable(parent: HTMLElement): void;
    protected getFallbackValue(): number;
    protected handleUserInteraction(): void;
    protected handleBlur(): Promise<void>;
    protected doHandleValueChange(): void;
    protected getInputValidation(input: string): PreferenceNumberInputValidation;
    protected showErrorMessage(message: string): void;
    protected hideErrorMessage(): void;
}
export {};
//# sourceMappingURL=preference-number-input.d.ts.map