"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindPreferencesWidgets = void 0;
const browser_1 = require("@theia/core/lib/browser");
const preference_node_renderer_1 = require("./components/preference-node-renderer");
const preference_widget_1 = require("./preference-widget");
const preference_tree_widget_1 = require("./preference-tree-widget");
const preference_editor_widget_1 = require("./preference-editor-widget");
const preference_searchbar_widget_1 = require("./preference-searchbar-widget");
const preference_scope_tabbar_widget_1 = require("./preference-scope-tabbar-widget");
const preference_tree_model_1 = require("../preference-tree-model");
const preference_tree_label_provider_1 = require("../util/preference-tree-label-provider");
const preference_types_1 = require("../util/preference-types");
const preference_string_input_1 = require("./components/preference-string-input");
const preference_boolean_input_1 = require("./components/preference-boolean-input");
const preference_json_input_1 = require("./components/preference-json-input");
const preference_select_input_1 = require("./components/preference-select-input");
const preference_number_input_1 = require("./components/preference-number-input");
const preference_array_input_1 = require("./components/preference-array-input");
function bindPreferencesWidgets(bind) {
    bind(preference_tree_label_provider_1.PreferenceTreeLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(preference_tree_label_provider_1.PreferenceTreeLabelProvider);
    bind(preference_widget_1.PreferencesWidget)
        .toDynamicValue(({ container }) => createPreferencesWidgetContainer(container).get(preference_widget_1.PreferencesWidget))
        .inSingletonScope();
    bind(browser_1.WidgetFactory).toDynamicValue(({ container }) => ({
        id: preference_widget_1.PreferencesWidget.ID,
        createWidget: () => container.get(preference_widget_1.PreferencesWidget)
    })).inSingletonScope();
    bind(preference_select_input_1.PreferenceSelectInputRenderer).toSelf();
    bind(preference_array_input_1.PreferenceArrayInputRenderer).toSelf();
    bind(preference_string_input_1.PreferenceStringInputRenderer).toSelf();
    bind(preference_boolean_input_1.PreferenceBooleanInputRenderer).toSelf();
    bind(preference_number_input_1.PreferenceNumberInputRenderer).toSelf();
    bind(preference_json_input_1.PreferenceJSONLinkRenderer).toSelf();
    bind(preference_node_renderer_1.PreferenceHeaderRenderer).toSelf();
}
exports.bindPreferencesWidgets = bindPreferencesWidgets;
function createPreferencesWidgetContainer(parent) {
    const child = browser_1.createTreeContainer(parent);
    child.bind(preference_tree_model_1.PreferenceTreeModel).toSelf();
    child.rebind(browser_1.TreeModel).toService(preference_tree_model_1.PreferenceTreeModel);
    child.unbind(browser_1.TreeWidget);
    child.bind(preference_tree_widget_1.PreferencesTreeWidget).toSelf();
    child.rebind(browser_1.TreeProps).toConstantValue(Object.assign(Object.assign({}, browser_1.defaultTreeProps), { search: false }));
    child.bind(preference_editor_widget_1.PreferencesEditorWidget).toSelf();
    child.bind(preference_searchbar_widget_1.PreferencesSearchbarWidget).toSelf();
    child.bind(preference_scope_tabbar_widget_1.PreferencesScopeTabBar).toSelf();
    child.bind(preference_widget_1.PreferencesWidget).toSelf();
    child.bind(preference_node_renderer_1.PreferenceNodeRendererFactory).toFactory(({ container }) => (node) => {
        var _a;
        const grandchild = container.createChild();
        grandchild.bind(preference_types_1.Preference.Node).toConstantValue(node);
        if (preference_types_1.Preference.LeafNode.is(node)) {
            if (node.preference.data.enum) {
                return grandchild.get(preference_select_input_1.PreferenceSelectInputRenderer);
            }
            const type = Array.isArray(node.preference.data.type) ? node.preference.data.type[0] : node.preference.data.type;
            if (type === 'array' && ((_a = node.preference.data.items) === null || _a === void 0 ? void 0 : _a.type) === 'string') {
                return grandchild.get(preference_array_input_1.PreferenceArrayInputRenderer);
            }
            switch (type) {
                case 'string':
                    return grandchild.get(preference_string_input_1.PreferenceStringInputRenderer);
                case 'boolean':
                    return grandchild.get(preference_boolean_input_1.PreferenceBooleanInputRenderer);
                case 'number':
                case 'integer':
                    return grandchild.get(preference_number_input_1.PreferenceNumberInputRenderer);
                default:
                    return grandchild.get(preference_json_input_1.PreferenceJSONLinkRenderer);
            }
        }
        else {
            return grandchild.get(preference_node_renderer_1.PreferenceHeaderRenderer);
        }
    });
    return child;
}
//# sourceMappingURL=preference-widget-bindings.js.map