/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Panel, Widget, Message, StatefulWidget, PreferenceScope } from '@theia/core/lib/browser';
import { PreferencesEditorState, PreferencesEditorWidget } from './preference-editor-widget';
import { PreferencesTreeWidget } from './preference-tree-widget';
import { PreferencesSearchbarState, PreferencesSearchbarWidget } from './preference-searchbar-widget';
import { PreferencesScopeTabBar, PreferencesScopeTabBarState } from './preference-scope-tabbar-widget';
import { Preference } from '../util/preference-types';
import URI from '@theia/core/lib/common/uri';
interface PreferencesWidgetState {
    scopeTabBarState: PreferencesScopeTabBarState;
    editorState: PreferencesEditorState;
    searchbarWidgetState: PreferencesSearchbarState;
}
export declare class PreferencesWidget extends Panel implements StatefulWidget {
    /**
     * The widget `id`.
     */
    static readonly ID = "settings_widget";
    /**
     * The widget `label` which is used for display purposes.
     */
    static readonly LABEL = "Preferences";
    protected readonly editorWidget: PreferencesEditorWidget;
    protected readonly treeWidget: PreferencesTreeWidget;
    protected readonly searchbarWidget: PreferencesSearchbarWidget;
    protected readonly tabBarWidget: PreferencesScopeTabBar;
    get currentScope(): Preference.SelectedScopeDetails;
    setSearchTerm(query: string): void;
    setScope(scope: PreferenceScope.User | PreferenceScope.Workspace | URI): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onActivateRequest(msg: Message): void;
    protected init(): void;
    storeState(): PreferencesWidgetState;
    restoreState(state: PreferencesWidgetState): void;
}
export {};
//# sourceMappingURL=preference-widget.d.ts.map