/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from '@theia/core/shared/inversify';
import { PreferenceProxy, PreferenceService, PreferenceSchema } from '@theia/core/lib/browser';
export declare const PreviewConfigSchema: PreferenceSchema;
export interface PreviewConfiguration {
    'preview.openByDefault': boolean;
}
export declare const PreviewPreferenceContribution: unique symbol;
export declare const PreviewPreferences: unique symbol;
export declare type PreviewPreferences = PreferenceProxy<PreviewConfiguration>;
export declare function createPreviewPreferences(preferences: PreferenceService, schema?: PreferenceSchema): PreviewPreferences;
export declare function bindPreviewPreferences(bind: interfaces.Bind): void;
//# sourceMappingURL=preview-preferences.d.ts.map