/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import { ReactWidget } from '@theia/core/lib/browser';
import * as React from '@theia/core/shared/react';
import { PropertyViewContentWidget } from './property-view-content-widget';
import { DefaultPropertyViewWidgetProvider } from './property-view-widget-provider';
declare class EmptyPropertyViewWidget extends ReactWidget implements PropertyViewContentWidget {
    static readonly ID = "theia-empty-property-view";
    static readonly LABEL = "No Properties";
    constructor();
    updatePropertyViewContent(): void;
    protected render(): React.ReactNode;
    protected emptyComponent: JSX.Element;
}
/**
 * `DefaultPropertyViewWidgetProvider` is implemented to provide the PropertyViewEmptyWidget
 *  if the given selection is undefined or no other provider can handle the given selection.
 */
export declare class EmptyPropertyViewWidgetProvider extends DefaultPropertyViewWidgetProvider {
    static readonly ID = "no-properties";
    readonly id = "no-properties";
    readonly label = "DefaultPropertyViewWidgetProvider";
    private emptyWidget;
    constructor();
    canHandle(selection: Object | undefined): number;
    provideWidget(selection: Object | undefined): Promise<EmptyPropertyViewWidget>;
    updateContentWidget(selection: Object | undefined): void;
}
export {};
//# sourceMappingURL=empty-property-view-widget-provider.d.ts.map