/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import { ContextMenuRenderer, LabelProvider, NodeProps, TreeModel, TreeNode, TreeProps, TreeWidget } from '@theia/core/lib/browser';
import { FileStat } from '@theia/filesystem/lib/common/files';
import * as React from '@theia/core/shared/react';
import { PropertyDataService } from '../property-data-service';
import { PropertyViewContentWidget } from '../property-view-content-widget';
import { ResourcePropertiesCategoryNode, ResourcePropertiesItemNode } from './resource-property-view-tree-items';
export declare class ResourcePropertyViewTreeWidget extends TreeWidget implements PropertyViewContentWidget {
    readonly props: TreeProps;
    protected readonly contextMenuRenderer: ContextMenuRenderer;
    static readonly ID = "resource-properties-tree-widget";
    static readonly LABEL = "Resource Properties Tree";
    protected propertiesTree: Map<string, ResourcePropertiesCategoryNode>;
    protected currentSelection: Object | undefined;
    protected readonly labelProvider: LabelProvider;
    constructor(props: TreeProps, model: TreeModel, contextMenuRenderer: ContextMenuRenderer);
    protected init(): void;
    protected updateNeeded(selection: Object | undefined): boolean;
    updatePropertyViewContent(propertyDataService?: PropertyDataService, selection?: Object | undefined): void;
    protected fillPropertiesTree(fileStatObject?: FileStat): void;
    protected getLocationString(fileStat: FileStat): string;
    protected getFileName(fileStat: FileStat): string;
    protected getFilePath(fileStat: FileStat): string;
    protected getLastModificationString(fileStat: FileStat): string;
    protected getCreationTimeString(fileStat: FileStat): string;
    protected getSizeString(fileStat: FileStat): string;
    protected createCategoryNode(categoryId: string, name: string): ResourcePropertiesCategoryNode;
    protected createResultLineNode(id: string, name: string, property: boolean | string | undefined, parent: ResourcePropertiesCategoryNode): ResourcePropertiesItemNode;
    /**
     * Rendering
     */
    protected refreshModelChildren(): Promise<void>;
    protected renderCaption(node: TreeNode, props: NodeProps): React.ReactNode;
    protected renderExpandableNode(node: ResourcePropertiesCategoryNode): React.ReactNode;
    protected renderItemNode(node: ResourcePropertiesItemNode): React.ReactNode;
    protected createNodeAttributes(node: TreeNode, props: NodeProps): React.Attributes & React.HTMLAttributes<HTMLElement>;
    protected getNodeTooltip(node: TreeNode): string | undefined;
}
//# sourceMappingURL=resource-property-view-tree-widget.d.ts.map