/********************************************************************************
 * Copyright (C) 2020 Arm and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { DisposableCollection } from '@theia/core/lib/common/disposable';
import { ScmService } from './scm-service';
import { ScmTreeModel } from './scm-tree-model';
import { ScmResourceGroup, ScmProvider } from './scm-provider';
export declare class ScmGroupsTreeModel extends ScmTreeModel {
    protected readonly scmService: ScmService;
    protected readonly toDisposeOnRepositoryChange: DisposableCollection;
    protected init(): void;
    protected refreshOnRepositoryChange(): void;
    protected changeRepository(provider: ScmProvider | undefined): void;
    get rootUri(): string | undefined;
    get groups(): ScmResourceGroup[];
    canTabToWidget(): boolean;
}
//# sourceMappingURL=scm-groups-tree-model.d.ts.map