/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
/// <reference types="lodash" />
import * as React from '@theia/core/shared/react';
interface HistoryState {
    history: string[];
    index: number;
}
declare type InputAttributes = React.InputHTMLAttributes<HTMLInputElement>;
export declare class SearchInWorkspaceInput extends React.Component<InputAttributes, HistoryState> {
    static LIMIT: number;
    private input;
    constructor(props: InputAttributes);
    setHistory(history: string[]): void;
    setIndex(index: number): void;
    get value(): string;
    set value(value: string);
    /**
     * Handle history navigation without overriding the parent's onKeyDown handler, if any.
     */
    protected readonly onKeyDown: (e: React.KeyboardEvent<HTMLInputElement>) => void;
    /**
     * Switch the input's text to the previous value, if any.
     */
    previousValue(): void;
    /**
     * Switch the input's text to the next value, if any.
     */
    nextValue(): void;
    /**
     * Handle history collection without overriding the parent's onChange handler, if any.
     */
    protected readonly onChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    /**
     * Add a nonempty current value to the history, if not already present. (Debounced, 1 second delay.)
     */
    readonly addToHistory: import("lodash").DebouncedFunc<() => void>;
    private doAddToHistory;
    render(): React.ReactNode;
}
export {};
//# sourceMappingURL=search-in-workspace-input.d.ts.map