/********************************************************************************
 * Copyright (C) 2021 ByteDance and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { TaskConfiguration } from '../../common';
import { Task } from '../task';
import { TaskRunner } from '../task-runner';
import { ILogger } from '@theia/core';
import { TaskFactory } from './custom-task';
import { TerminalProcessFactory } from '@theia/process/lib/node';
/**
 * Task runner that runs a task as a pseudoterminal open.
 */
export declare class CustomTaskRunner implements TaskRunner {
    protected readonly logger: ILogger;
    protected readonly terminalProcessFactory: TerminalProcessFactory;
    protected readonly taskFactory: TaskFactory;
    run(taskConfig: TaskConfiguration, ctx?: string): Promise<Task>;
}
//# sourceMappingURL=custom-task-runner.d.ts.map