/********************************************************************************
 * Copyright (C) 2021 ByteDance and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { ILogger, MaybePromise } from '@theia/core/lib/common/';
import { Task, TaskOptions } from '../task';
import { TaskManager } from '../task-manager';
import { TaskInfo } from '../../common/task-protocol';
import { Process } from '@theia/process/lib/node';
export declare const TaskCustomOptions: unique symbol;
export interface TaskCustomOptions extends TaskOptions {
    process: Process;
}
export declare const TaskFactory: unique symbol;
export declare type TaskFactory = (options: TaskCustomOptions) => CustomTask;
/** Represents a Task launched as a fake process by `CustomTaskRunner`. */
export declare class CustomTask extends Task {
    protected readonly taskManager: TaskManager;
    protected readonly logger: ILogger;
    protected readonly options: TaskCustomOptions;
    constructor(taskManager: TaskManager, logger: ILogger, options: TaskCustomOptions);
    kill(): Promise<void>;
    getRuntimeInfo(): MaybePromise<TaskInfo>;
    callbackTaskComplete(exitCode: number | undefined): MaybePromise<void>;
    get process(): Process;
}
//# sourceMappingURL=custom-task.d.ts.map