/********************************************************************************
 * Copyright (C) 2019 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { QuickAccessContribution, QuickAccessProvider, QuickAccessRegistry, QuickInputService } from '@theia/core/lib/browser';
import { CancellationToken, CommandContribution, CommandRegistry, CommandService } from '@theia/core/lib/common';
import { TerminalWidget } from './base/terminal-widget';
import { TerminalService } from './base/terminal-service';
import { QuickPickItem, QuickPicks } from '@theia/core/lib/browser/quick-input/quick-input-service';
export declare class TerminalQuickOpenService implements QuickAccessProvider {
    static readonly PREFIX = "term ";
    protected readonly quickInputService: QuickInputService;
    protected readonly quickAccessRegistry: QuickAccessRegistry;
    protected readonly commandService: CommandService;
    protected readonly terminalService: TerminalService;
    open(): void;
    getPicks(filter: string, token: CancellationToken): Promise<QuickPicks>;
    registerQuickAccessProvider(): void;
    /**
     * Compare two terminal widgets by label. If labels are identical, compare by the widget id.
     * @param a `TerminalWidget` for comparison
     * @param b `TerminalWidget` for comparison
     */
    protected compareItems(a: TerminalWidget, b: TerminalWidget): number;
    protected doCreateNewTerminal(): void;
    /**
     * Convert the terminal widget to the quick pick item.
     * @param {TerminalWidget} widget - the terminal widget.
     * @returns quick pick item.
     */
    protected toItem(widget: TerminalWidget): QuickPickItem;
}
/**
 * TODO: merge it to TerminalFrontendContribution.
 */
export declare class TerminalQuickOpenContribution implements CommandContribution, QuickAccessContribution {
    protected readonly terminalQuickOpenService: TerminalQuickOpenService;
    registerQuickAccessProvider(): void;
    registerCommands(commands: CommandRegistry): void;
}
//# sourceMappingURL=terminal-quick-open-service.d.ts.map