/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { FolderPreferenceProvider, UserPreferenceProvider } from '@theia/preferences/lib/browser';
import { interfaces } from '@theia/core/shared/inversify';
import { WorkspaceFilePreferenceProvider } from '@theia/preferences/lib/browser/workspace-file-preference-provider';
/**
 * The overrides in this file are required because the base preference providers assume that a
 * section name (extensions) will not be used as a prefix (extensions.ignoreRecommendations).
 */
export declare class FolderPreferenceProviderWithExtensions extends FolderPreferenceProvider {
    protected getPath(preferenceName: string): string[] | undefined;
}
export declare class UserPreferenceProviderWithExtensions extends UserPreferenceProvider {
    protected getPath(preferenceName: string): string[] | undefined;
}
export declare class WorkspaceFilePreferenceProviderWithExtensions extends WorkspaceFilePreferenceProvider {
    protected belongsInSection(firstSegment: string, remainder: string): boolean;
}
export declare function bindPreferenceProviderOverrides(bind: interfaces.Bind, unbind: interfaces.Unbind): void;
//# sourceMappingURL=preference-provider-overrides.d.ts.map