/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { InMemoryResources } from '@theia/core';
import { JsonSchemaContribution, JsonSchemaRegisterContext } from '@theia/core/lib/browser/json-schema-store';
import { IJSONSchema } from '@theia/core/lib/common/json-schema';
import URI from '@theia/core/lib/common/uri';
import { WorkspaceService } from '@theia/workspace/lib/browser';
export declare const extensionsSchemaID = "vscode://schemas/extensions";
export declare const extensionsConfigurationSchema: IJSONSchema;
export declare class ExtensionSchemaContribution implements JsonSchemaContribution {
    protected readonly uri: URI;
    protected readonly inmemoryResources: InMemoryResources;
    protected readonly workspaceService: WorkspaceService;
    protected init(): void;
    registerSchemas(context: JsonSchemaRegisterContext): void;
}
//# sourceMappingURL=recommended-extensions-json-schema.d.ts.map