/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CommandRegistry } from '@theia/core/lib/common/command';
import { AbstractViewContribution } from '@theia/core/lib/browser/shell/view-contribution';
import { VSXExtensionsViewContainer } from './vsx-extensions-view-container';
import { VSXExtensionsModel } from './vsx-extensions-model';
import { ColorContribution } from '@theia/core/lib/browser/color-application-contribution';
import { ColorRegistry } from '@theia/core/lib/browser/color-registry';
import { FrontendApplicationContribution, FrontendApplication } from '@theia/core/lib/browser/frontend-application';
import { MenuModelRegistry, MessageService } from '@theia/core/lib/common';
import { FileDialogService } from '@theia/filesystem/lib/browser';
import { LabelProvider, PreferenceService } from '@theia/core/lib/browser';
import { VSXExtension } from './vsx-extension';
import { ClipboardService } from '@theia/core/lib/browser/clipboard-service';
import { VSXExtensionsCommands } from './vsx-extension-commands';
/**
 * @deprecated since 1.17.0. - Moved to `vsx-extension-commands.ts` to avoid circular dependencies. Import from there, instead.
 */
export { VSXExtensionsCommands };
export declare class VSXExtensionsContribution extends AbstractViewContribution<VSXExtensionsViewContainer> implements ColorContribution, FrontendApplicationContribution {
    protected readonly model: VSXExtensionsModel;
    protected readonly commandRegistry: CommandRegistry;
    protected readonly fileDialogService: FileDialogService;
    protected readonly messageService: MessageService;
    protected readonly labelProvider: LabelProvider;
    protected readonly clipboardService: ClipboardService;
    protected readonly preferenceService: PreferenceService;
    constructor();
    protected init(): void;
    initializeLayout(app: FrontendApplication): Promise<void>;
    registerCommands(commands: CommandRegistry): void;
    registerMenus(menus: MenuModelRegistry): void;
    registerColors(colors: ColorRegistry): void;
    /**
     * Installs a local .vsix file after prompting the `Open File` dialog. Resolves to the URI of the file.
     */
    protected installFromVSIX(): Promise<void>;
    protected copy(extension: VSXExtension): Promise<void>;
    protected copyExtensionId(extension: VSXExtension): void;
    protected showRecommendedToast(): Promise<void>;
    protected showBuiltinExtensions(): Promise<void>;
    protected showInstalledExtensions(): Promise<void>;
    protected showRecommendedExtensions(): Promise<void>;
}
//# sourceMappingURL=vsx-extensions-contribution.d.ts.map