/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Emitter } from '@theia/core/lib/common/event';
export declare enum VSXSearchMode {
    Initial = 0,
    None = 1,
    Search = 2,
    Installed = 3,
    Builtin = 4,
    Recommended = 5
}
export declare const BUILTIN_QUERY = "@builtin";
export declare const INSTALLED_QUERY = "@installed";
export declare const RECOMMENDED_QUERY = "@recommended";
export declare class VSXExtensionsSearchModel {
    protected readonly onDidChangeQueryEmitter: Emitter<string>;
    readonly onDidChangeQuery: import("@theia/core/lib/common/event").Event<string>;
    protected readonly specialQueries: Map<string, VSXSearchMode>;
    protected _query: string;
    set query(query: string);
    get query(): string;
    getModeForQuery(): VSXSearchMode;
}
//# sourceMappingURL=vsx-extensions-search-model.d.ts.map