/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from '@theia/core/shared/inversify';
import { SourceTreeWidget } from '@theia/core/lib/browser/source-tree';
import { VSXExtensionsSource, VSXExtensionsSourceOptions } from './vsx-extensions-source';
export declare class VSXExtensionsWidgetOptions extends VSXExtensionsSourceOptions {
    title?: string;
}
export declare const generateExtensionWidgetId: (widgetId: string) => string;
export declare class VSXExtensionsWidget extends SourceTreeWidget {
    static ID: string;
    static createWidget(parent: interfaces.Container, options: VSXExtensionsWidgetOptions): VSXExtensionsWidget;
    protected readonly options: VSXExtensionsWidgetOptions;
    protected readonly extensionsSource: VSXExtensionsSource;
    protected init(): void;
    protected computeTitle(): string;
}
//# sourceMappingURL=vsx-extensions-widget.d.ts.map