// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListEventsParams creates a new ListEventsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListEventsParams() *ListEventsParams {
	return &ListEventsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListEventsParamsWithTimeout creates a new ListEventsParams object
// with the ability to set a timeout on a request.
func NewListEventsParamsWithTimeout(timeout time.Duration) *ListEventsParams {
	return &ListEventsParams{
		timeout: timeout,
	}
}

// NewListEventsParamsWithContext creates a new ListEventsParams object
// with the ability to set a context for a request.
func NewListEventsParamsWithContext(ctx context.Context) *ListEventsParams {
	return &ListEventsParams{
		Context: ctx,
	}
}

// NewListEventsParamsWithHTTPClient creates a new ListEventsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListEventsParamsWithHTTPClient(client *http.Client) *ListEventsParams {
	return &ListEventsParams{
		HTTPClient: client,
	}
}

/* ListEventsParams contains all the parameters to send to the API endpoint
   for the list events operation.

   Typically these are written to a http.Request.
*/
type ListEventsParams struct {

	/* Categories.

	   A comma-separated list of event categories.
	*/
	Categories []string

	/* ClusterID.

	   The cluster to return events for.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   A host in the specified cluster to return events for.

	   Format: uuid
	*/
	HostID *strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListEventsParams) WithDefaults() *ListEventsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListEventsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list events params
func (o *ListEventsParams) WithTimeout(timeout time.Duration) *ListEventsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list events params
func (o *ListEventsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list events params
func (o *ListEventsParams) WithContext(ctx context.Context) *ListEventsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list events params
func (o *ListEventsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list events params
func (o *ListEventsParams) WithHTTPClient(client *http.Client) *ListEventsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list events params
func (o *ListEventsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCategories adds the categories to the list events params
func (o *ListEventsParams) WithCategories(categories []string) *ListEventsParams {
	o.SetCategories(categories)
	return o
}

// SetCategories adds the categories to the list events params
func (o *ListEventsParams) SetCategories(categories []string) {
	o.Categories = categories
}

// WithClusterID adds the clusterID to the list events params
func (o *ListEventsParams) WithClusterID(clusterID strfmt.UUID) *ListEventsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the list events params
func (o *ListEventsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the list events params
func (o *ListEventsParams) WithHostID(hostID *strfmt.UUID) *ListEventsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the list events params
func (o *ListEventsParams) SetHostID(hostID *strfmt.UUID) {
	o.HostID = hostID
}

// WriteToRequest writes these params to a swagger request
func (o *ListEventsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Categories != nil {

		// binding items for categories
		joinedCategories := o.bindParamCategories(reg)

		// query array param categories
		if err := r.SetQueryParam("categories", joinedCategories...); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.HostID != nil {

		// query param host_id
		var qrHostID strfmt.UUID

		if o.HostID != nil {
			qrHostID = *o.HostID
		}
		qHostID := qrHostID.String()
		if qHostID != "" {

			if err := r.SetQueryParam("host_id", qHostID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListEvents binds the parameter categories
func (o *ListEventsParams) bindParamCategories(formats strfmt.Registry) []string {
	categoriesIR := o.Categories

	var categoriesIC []string
	for _, categoriesIIR := range categoriesIR { // explode []string

		categoriesIIV := categoriesIIR // string as string
		categoriesIC = append(categoriesIC, categoriesIIV)
	}

	// items.CollectionFormat: ""
	categoriesIS := swag.JoinByFormat(categoriesIC, "")

	return categoriesIS
}
