// Code generated by go-swagger; DO NOT EDIT.

package events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// ListEventsReader is a Reader for the ListEvents structure.
type ListEventsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListEventsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListEventsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewListEventsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListEventsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewListEventsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewListEventsMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListEventsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewListEventsOK creates a ListEventsOK with default headers values
func NewListEventsOK() *ListEventsOK {
	return &ListEventsOK{}
}

/* ListEventsOK describes a response with status code 200, with default header values.

Success.
*/
type ListEventsOK struct {
	Payload models.EventList
}

func (o *ListEventsOK) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsOK  %+v", 200, o.Payload)
}
func (o *ListEventsOK) GetPayload() models.EventList {
	return o.Payload
}

func (o *ListEventsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListEventsUnauthorized creates a ListEventsUnauthorized with default headers values
func NewListEventsUnauthorized() *ListEventsUnauthorized {
	return &ListEventsUnauthorized{}
}

/* ListEventsUnauthorized describes a response with status code 401, with default header values.

Unauthorized.
*/
type ListEventsUnauthorized struct {
	Payload *models.InfraError
}

func (o *ListEventsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsUnauthorized  %+v", 401, o.Payload)
}
func (o *ListEventsUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListEventsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListEventsForbidden creates a ListEventsForbidden with default headers values
func NewListEventsForbidden() *ListEventsForbidden {
	return &ListEventsForbidden{}
}

/* ListEventsForbidden describes a response with status code 403, with default header values.

Forbidden.
*/
type ListEventsForbidden struct {
	Payload *models.InfraError
}

func (o *ListEventsForbidden) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsForbidden  %+v", 403, o.Payload)
}
func (o *ListEventsForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *ListEventsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListEventsNotFound creates a ListEventsNotFound with default headers values
func NewListEventsNotFound() *ListEventsNotFound {
	return &ListEventsNotFound{}
}

/* ListEventsNotFound describes a response with status code 404, with default header values.

Error.
*/
type ListEventsNotFound struct {
	Payload *models.Error
}

func (o *ListEventsNotFound) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsNotFound  %+v", 404, o.Payload)
}
func (o *ListEventsNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListEventsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListEventsMethodNotAllowed creates a ListEventsMethodNotAllowed with default headers values
func NewListEventsMethodNotAllowed() *ListEventsMethodNotAllowed {
	return &ListEventsMethodNotAllowed{}
}

/* ListEventsMethodNotAllowed describes a response with status code 405, with default header values.

Method Not Allowed.
*/
type ListEventsMethodNotAllowed struct {
	Payload *models.Error
}

func (o *ListEventsMethodNotAllowed) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsMethodNotAllowed  %+v", 405, o.Payload)
}
func (o *ListEventsMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListEventsMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListEventsInternalServerError creates a ListEventsInternalServerError with default headers values
func NewListEventsInternalServerError() *ListEventsInternalServerError {
	return &ListEventsInternalServerError{}
}

/* ListEventsInternalServerError describes a response with status code 500, with default header values.

Error.
*/
type ListEventsInternalServerError struct {
	Payload *models.Error
}

func (o *ListEventsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /v1/clusters/{cluster_id}/events][%d] listEventsInternalServerError  %+v", 500, o.Payload)
}
func (o *ListEventsInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *ListEventsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
