// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeregisterHostParams creates a new DeregisterHostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeregisterHostParams() *DeregisterHostParams {
	return &DeregisterHostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeregisterHostParamsWithTimeout creates a new DeregisterHostParams object
// with the ability to set a timeout on a request.
func NewDeregisterHostParamsWithTimeout(timeout time.Duration) *DeregisterHostParams {
	return &DeregisterHostParams{
		timeout: timeout,
	}
}

// NewDeregisterHostParamsWithContext creates a new DeregisterHostParams object
// with the ability to set a context for a request.
func NewDeregisterHostParamsWithContext(ctx context.Context) *DeregisterHostParams {
	return &DeregisterHostParams{
		Context: ctx,
	}
}

// NewDeregisterHostParamsWithHTTPClient creates a new DeregisterHostParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeregisterHostParamsWithHTTPClient(client *http.Client) *DeregisterHostParams {
	return &DeregisterHostParams{
		HTTPClient: client,
	}
}

/* DeregisterHostParams contains all the parameters to send to the API endpoint
   for the deregister host operation.

   Typically these are written to a http.Request.
*/
type DeregisterHostParams struct {

	/* ClusterID.

	   The cluster of the host that should be deregistered.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host that should be deregistered.

	   Format: uuid
	*/
	HostID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the deregister host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeregisterHostParams) WithDefaults() *DeregisterHostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the deregister host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeregisterHostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the deregister host params
func (o *DeregisterHostParams) WithTimeout(timeout time.Duration) *DeregisterHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the deregister host params
func (o *DeregisterHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the deregister host params
func (o *DeregisterHostParams) WithContext(ctx context.Context) *DeregisterHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the deregister host params
func (o *DeregisterHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the deregister host params
func (o *DeregisterHostParams) WithHTTPClient(client *http.Client) *DeregisterHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the deregister host params
func (o *DeregisterHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the deregister host params
func (o *DeregisterHostParams) WithClusterID(clusterID strfmt.UUID) *DeregisterHostParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the deregister host params
func (o *DeregisterHostParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the deregister host params
func (o *DeregisterHostParams) WithHostID(hostID strfmt.UUID) *DeregisterHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the deregister host params
func (o *DeregisterHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WriteToRequest writes these params to a swagger request
func (o *DeregisterHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
