// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDownloadClusterFilesParams creates a new DownloadClusterFilesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDownloadClusterFilesParams() *DownloadClusterFilesParams {
	return &DownloadClusterFilesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadClusterFilesParamsWithTimeout creates a new DownloadClusterFilesParams object
// with the ability to set a timeout on a request.
func NewDownloadClusterFilesParamsWithTimeout(timeout time.Duration) *DownloadClusterFilesParams {
	return &DownloadClusterFilesParams{
		timeout: timeout,
	}
}

// NewDownloadClusterFilesParamsWithContext creates a new DownloadClusterFilesParams object
// with the ability to set a context for a request.
func NewDownloadClusterFilesParamsWithContext(ctx context.Context) *DownloadClusterFilesParams {
	return &DownloadClusterFilesParams{
		Context: ctx,
	}
}

// NewDownloadClusterFilesParamsWithHTTPClient creates a new DownloadClusterFilesParams object
// with the ability to set a custom HTTPClient for a request.
func NewDownloadClusterFilesParamsWithHTTPClient(client *http.Client) *DownloadClusterFilesParams {
	return &DownloadClusterFilesParams{
		HTTPClient: client,
	}
}

/* DownloadClusterFilesParams contains all the parameters to send to the API endpoint
   for the download cluster files operation.

   Typically these are written to a http.Request.
*/
type DownloadClusterFilesParams struct {

	/* ClusterID.

	   The cluster that owns the file that should be downloaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is downloading the file.
	*/
	DiscoveryAgentVersion *string

	/* FileName.

	   The file to be downloaded.
	*/
	FileName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the download cluster files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadClusterFilesParams) WithDefaults() *DownloadClusterFilesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the download cluster files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadClusterFilesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the download cluster files params
func (o *DownloadClusterFilesParams) WithTimeout(timeout time.Duration) *DownloadClusterFilesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download cluster files params
func (o *DownloadClusterFilesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download cluster files params
func (o *DownloadClusterFilesParams) WithContext(ctx context.Context) *DownloadClusterFilesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download cluster files params
func (o *DownloadClusterFilesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download cluster files params
func (o *DownloadClusterFilesParams) WithHTTPClient(client *http.Client) *DownloadClusterFilesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download cluster files params
func (o *DownloadClusterFilesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the download cluster files params
func (o *DownloadClusterFilesParams) WithClusterID(clusterID strfmt.UUID) *DownloadClusterFilesParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the download cluster files params
func (o *DownloadClusterFilesParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the download cluster files params
func (o *DownloadClusterFilesParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *DownloadClusterFilesParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the download cluster files params
func (o *DownloadClusterFilesParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithFileName adds the fileName to the download cluster files params
func (o *DownloadClusterFilesParams) WithFileName(fileName string) *DownloadClusterFilesParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the download cluster files params
func (o *DownloadClusterFilesParams) SetFileName(fileName string) {
	o.FileName = fileName
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadClusterFilesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}

	// query param file_name
	qrFileName := o.FileName
	qFileName := qrFileName
	if qFileName != "" {

		if err := r.SetQueryParam("file_name", qFileName); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
