// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDownloadHostIgnitionParams creates a new DownloadHostIgnitionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDownloadHostIgnitionParams() *DownloadHostIgnitionParams {
	return &DownloadHostIgnitionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadHostIgnitionParamsWithTimeout creates a new DownloadHostIgnitionParams object
// with the ability to set a timeout on a request.
func NewDownloadHostIgnitionParamsWithTimeout(timeout time.Duration) *DownloadHostIgnitionParams {
	return &DownloadHostIgnitionParams{
		timeout: timeout,
	}
}

// NewDownloadHostIgnitionParamsWithContext creates a new DownloadHostIgnitionParams object
// with the ability to set a context for a request.
func NewDownloadHostIgnitionParamsWithContext(ctx context.Context) *DownloadHostIgnitionParams {
	return &DownloadHostIgnitionParams{
		Context: ctx,
	}
}

// NewDownloadHostIgnitionParamsWithHTTPClient creates a new DownloadHostIgnitionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDownloadHostIgnitionParamsWithHTTPClient(client *http.Client) *DownloadHostIgnitionParams {
	return &DownloadHostIgnitionParams{
		HTTPClient: client,
	}
}

/* DownloadHostIgnitionParams contains all the parameters to send to the API endpoint
   for the download host ignition operation.

   Typically these are written to a http.Request.
*/
type DownloadHostIgnitionParams struct {

	/* ClusterID.

	   The cluster of the host whose ignition file should be downloaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host whose ignition file should be downloaded.

	   Format: uuid
	*/
	HostID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the download host ignition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadHostIgnitionParams) WithDefaults() *DownloadHostIgnitionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the download host ignition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadHostIgnitionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the download host ignition params
func (o *DownloadHostIgnitionParams) WithTimeout(timeout time.Duration) *DownloadHostIgnitionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download host ignition params
func (o *DownloadHostIgnitionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download host ignition params
func (o *DownloadHostIgnitionParams) WithContext(ctx context.Context) *DownloadHostIgnitionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download host ignition params
func (o *DownloadHostIgnitionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download host ignition params
func (o *DownloadHostIgnitionParams) WithHTTPClient(client *http.Client) *DownloadHostIgnitionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download host ignition params
func (o *DownloadHostIgnitionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the download host ignition params
func (o *DownloadHostIgnitionParams) WithClusterID(clusterID strfmt.UUID) *DownloadHostIgnitionParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the download host ignition params
func (o *DownloadHostIgnitionParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the download host ignition params
func (o *DownloadHostIgnitionParams) WithHostID(hostID strfmt.UUID) *DownloadHostIgnitionParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the download host ignition params
func (o *DownloadHostIgnitionParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadHostIgnitionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
