// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDownloadHostLogsParams creates a new DownloadHostLogsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDownloadHostLogsParams() *DownloadHostLogsParams {
	return &DownloadHostLogsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadHostLogsParamsWithTimeout creates a new DownloadHostLogsParams object
// with the ability to set a timeout on a request.
func NewDownloadHostLogsParamsWithTimeout(timeout time.Duration) *DownloadHostLogsParams {
	return &DownloadHostLogsParams{
		timeout: timeout,
	}
}

// NewDownloadHostLogsParamsWithContext creates a new DownloadHostLogsParams object
// with the ability to set a context for a request.
func NewDownloadHostLogsParamsWithContext(ctx context.Context) *DownloadHostLogsParams {
	return &DownloadHostLogsParams{
		Context: ctx,
	}
}

// NewDownloadHostLogsParamsWithHTTPClient creates a new DownloadHostLogsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDownloadHostLogsParamsWithHTTPClient(client *http.Client) *DownloadHostLogsParams {
	return &DownloadHostLogsParams{
		HTTPClient: client,
	}
}

/* DownloadHostLogsParams contains all the parameters to send to the API endpoint
   for the download host logs operation.

   Typically these are written to a http.Request.
*/
type DownloadHostLogsParams struct {

	/* ClusterID.

	   The cluster of the host whose logs should be downloaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host whose logs should be downloaded.

	   Format: uuid
	*/
	HostID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the download host logs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadHostLogsParams) WithDefaults() *DownloadHostLogsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the download host logs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadHostLogsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the download host logs params
func (o *DownloadHostLogsParams) WithTimeout(timeout time.Duration) *DownloadHostLogsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download host logs params
func (o *DownloadHostLogsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download host logs params
func (o *DownloadHostLogsParams) WithContext(ctx context.Context) *DownloadHostLogsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download host logs params
func (o *DownloadHostLogsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download host logs params
func (o *DownloadHostLogsParams) WithHTTPClient(client *http.Client) *DownloadHostLogsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download host logs params
func (o *DownloadHostLogsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the download host logs params
func (o *DownloadHostLogsParams) WithClusterID(clusterID strfmt.UUID) *DownloadHostLogsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the download host logs params
func (o *DownloadHostLogsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the download host logs params
func (o *DownloadHostLogsParams) WithHostID(hostID strfmt.UUID) *DownloadHostLogsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the download host logs params
func (o *DownloadHostLogsParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadHostLogsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
