// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListClustersParams creates a new ListClustersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListClustersParams() *ListClustersParams {
	return &ListClustersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListClustersParamsWithTimeout creates a new ListClustersParams object
// with the ability to set a timeout on a request.
func NewListClustersParamsWithTimeout(timeout time.Duration) *ListClustersParams {
	return &ListClustersParams{
		timeout: timeout,
	}
}

// NewListClustersParamsWithContext creates a new ListClustersParams object
// with the ability to set a context for a request.
func NewListClustersParamsWithContext(ctx context.Context) *ListClustersParams {
	return &ListClustersParams{
		Context: ctx,
	}
}

// NewListClustersParamsWithHTTPClient creates a new ListClustersParams object
// with the ability to set a custom HTTPClient for a request.
func NewListClustersParamsWithHTTPClient(client *http.Client) *ListClustersParams {
	return &ListClustersParams{
		HTTPClient: client,
	}
}

/* ListClustersParams contains all the parameters to send to the API endpoint
   for the list clusters operation.

   Typically these are written to a http.Request.
*/
type ListClustersParams struct {

	/* AmsSubscriptionIds.

	   If non-empty, returned Clusters are filtered to those with matching subscription IDs.
	*/
	AmsSubscriptionIds []string

	/* GetUnregisteredClusters.

	   Whether to return clusters that have been unregistered.
	*/
	GetUnregisteredClusters *bool

	/* OpenshiftClusterID.

	   A specific cluster to retrieve.

	   Format: uuid
	*/
	OpenshiftClusterID *strfmt.UUID

	/* WithHosts.

	   Include hosts in the returned list.
	*/
	WithHosts bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list clusters params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClustersParams) WithDefaults() *ListClustersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list clusters params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClustersParams) SetDefaults() {
	var (
		getUnregisteredClustersDefault = bool(false)

		withHostsDefault = bool(false)
	)

	val := ListClustersParams{
		GetUnregisteredClusters: &getUnregisteredClustersDefault,
		WithHosts:               withHostsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the list clusters params
func (o *ListClustersParams) WithTimeout(timeout time.Duration) *ListClustersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list clusters params
func (o *ListClustersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list clusters params
func (o *ListClustersParams) WithContext(ctx context.Context) *ListClustersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list clusters params
func (o *ListClustersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list clusters params
func (o *ListClustersParams) WithHTTPClient(client *http.Client) *ListClustersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list clusters params
func (o *ListClustersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAmsSubscriptionIds adds the amsSubscriptionIds to the list clusters params
func (o *ListClustersParams) WithAmsSubscriptionIds(amsSubscriptionIds []string) *ListClustersParams {
	o.SetAmsSubscriptionIds(amsSubscriptionIds)
	return o
}

// SetAmsSubscriptionIds adds the amsSubscriptionIds to the list clusters params
func (o *ListClustersParams) SetAmsSubscriptionIds(amsSubscriptionIds []string) {
	o.AmsSubscriptionIds = amsSubscriptionIds
}

// WithGetUnregisteredClusters adds the getUnregisteredClusters to the list clusters params
func (o *ListClustersParams) WithGetUnregisteredClusters(getUnregisteredClusters *bool) *ListClustersParams {
	o.SetGetUnregisteredClusters(getUnregisteredClusters)
	return o
}

// SetGetUnregisteredClusters adds the getUnregisteredClusters to the list clusters params
func (o *ListClustersParams) SetGetUnregisteredClusters(getUnregisteredClusters *bool) {
	o.GetUnregisteredClusters = getUnregisteredClusters
}

// WithOpenshiftClusterID adds the openshiftClusterID to the list clusters params
func (o *ListClustersParams) WithOpenshiftClusterID(openshiftClusterID *strfmt.UUID) *ListClustersParams {
	o.SetOpenshiftClusterID(openshiftClusterID)
	return o
}

// SetOpenshiftClusterID adds the openshiftClusterId to the list clusters params
func (o *ListClustersParams) SetOpenshiftClusterID(openshiftClusterID *strfmt.UUID) {
	o.OpenshiftClusterID = openshiftClusterID
}

// WithWithHosts adds the withHosts to the list clusters params
func (o *ListClustersParams) WithWithHosts(withHosts bool) *ListClustersParams {
	o.SetWithHosts(withHosts)
	return o
}

// SetWithHosts adds the withHosts to the list clusters params
func (o *ListClustersParams) SetWithHosts(withHosts bool) {
	o.WithHosts = withHosts
}

// WriteToRequest writes these params to a swagger request
func (o *ListClustersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AmsSubscriptionIds != nil {

		// binding items for ams_subscription_ids
		joinedAmsSubscriptionIds := o.bindParamAmsSubscriptionIds(reg)

		// query array param ams_subscription_ids
		if err := r.SetQueryParam("ams_subscription_ids", joinedAmsSubscriptionIds...); err != nil {
			return err
		}
	}

	if o.GetUnregisteredClusters != nil {

		// header param get_unregistered_clusters
		if err := r.SetHeaderParam("get_unregistered_clusters", swag.FormatBool(*o.GetUnregisteredClusters)); err != nil {
			return err
		}
	}

	if o.OpenshiftClusterID != nil {

		// query param openshift_cluster_id
		var qrOpenshiftClusterID strfmt.UUID

		if o.OpenshiftClusterID != nil {
			qrOpenshiftClusterID = *o.OpenshiftClusterID
		}
		qOpenshiftClusterID := qrOpenshiftClusterID.String()
		if qOpenshiftClusterID != "" {

			if err := r.SetQueryParam("openshift_cluster_id", qOpenshiftClusterID); err != nil {
				return err
			}
		}
	}

	// query param with_hosts
	qrWithHosts := o.WithHosts
	qWithHosts := swag.FormatBool(qrWithHosts)

	if err := r.SetQueryParam("with_hosts", qWithHosts); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListClusters binds the parameter ams_subscription_ids
func (o *ListClustersParams) bindParamAmsSubscriptionIds(formats strfmt.Registry) []string {
	amsSubscriptionIdsIR := o.AmsSubscriptionIds

	var amsSubscriptionIdsIC []string
	for _, amsSubscriptionIdsIIR := range amsSubscriptionIdsIR { // explode []string

		amsSubscriptionIdsIIV := amsSubscriptionIdsIIR // string as string
		amsSubscriptionIdsIC = append(amsSubscriptionIdsIC, amsSubscriptionIdsIIV)
	}

	// items.CollectionFormat: ""
	amsSubscriptionIdsIS := swag.JoinByFormat(amsSubscriptionIdsIC, "")

	return amsSubscriptionIdsIS
}
