// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListHostsParams creates a new ListHostsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListHostsParams() *ListHostsParams {
	return &ListHostsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListHostsParamsWithTimeout creates a new ListHostsParams object
// with the ability to set a timeout on a request.
func NewListHostsParamsWithTimeout(timeout time.Duration) *ListHostsParams {
	return &ListHostsParams{
		timeout: timeout,
	}
}

// NewListHostsParamsWithContext creates a new ListHostsParams object
// with the ability to set a context for a request.
func NewListHostsParamsWithContext(ctx context.Context) *ListHostsParams {
	return &ListHostsParams{
		Context: ctx,
	}
}

// NewListHostsParamsWithHTTPClient creates a new ListHostsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListHostsParamsWithHTTPClient(client *http.Client) *ListHostsParams {
	return &ListHostsParams{
		HTTPClient: client,
	}
}

/* ListHostsParams contains all the parameters to send to the API endpoint
   for the list hosts operation.

   Typically these are written to a http.Request.
*/
type ListHostsParams struct {

	/* ClusterID.

	   The cluster whose hosts should be listed.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is listing hosts.
	*/
	DiscoveryAgentVersion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListHostsParams) WithDefaults() *ListHostsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListHostsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list hosts params
func (o *ListHostsParams) WithTimeout(timeout time.Duration) *ListHostsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list hosts params
func (o *ListHostsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list hosts params
func (o *ListHostsParams) WithContext(ctx context.Context) *ListHostsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list hosts params
func (o *ListHostsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list hosts params
func (o *ListHostsParams) WithHTTPClient(client *http.Client) *ListHostsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list hosts params
func (o *ListHostsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the list hosts params
func (o *ListHostsParams) WithClusterID(clusterID strfmt.UUID) *ListHostsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the list hosts params
func (o *ListHostsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the list hosts params
func (o *ListHostsParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *ListHostsParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the list hosts params
func (o *ListHostsParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WriteToRequest writes these params to a swagger request
func (o *ListHostsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
