// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListInfraEnvsParams creates a new ListInfraEnvsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListInfraEnvsParams() *ListInfraEnvsParams {
	return &ListInfraEnvsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListInfraEnvsParamsWithTimeout creates a new ListInfraEnvsParams object
// with the ability to set a timeout on a request.
func NewListInfraEnvsParamsWithTimeout(timeout time.Duration) *ListInfraEnvsParams {
	return &ListInfraEnvsParams{
		timeout: timeout,
	}
}

// NewListInfraEnvsParamsWithContext creates a new ListInfraEnvsParams object
// with the ability to set a context for a request.
func NewListInfraEnvsParamsWithContext(ctx context.Context) *ListInfraEnvsParams {
	return &ListInfraEnvsParams{
		Context: ctx,
	}
}

// NewListInfraEnvsParamsWithHTTPClient creates a new ListInfraEnvsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListInfraEnvsParamsWithHTTPClient(client *http.Client) *ListInfraEnvsParams {
	return &ListInfraEnvsParams{
		HTTPClient: client,
	}
}

/* ListInfraEnvsParams contains all the parameters to send to the API endpoint
   for the list infra envs operation.

   Typically these are written to a http.Request.
*/
type ListInfraEnvsParams struct {

	/* ClusterID.

	   If provided, returns only infra-envs which directly reference this cluster.

	   Format: uuid
	*/
	ClusterID *strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list infra envs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListInfraEnvsParams) WithDefaults() *ListInfraEnvsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list infra envs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListInfraEnvsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list infra envs params
func (o *ListInfraEnvsParams) WithTimeout(timeout time.Duration) *ListInfraEnvsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list infra envs params
func (o *ListInfraEnvsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list infra envs params
func (o *ListInfraEnvsParams) WithContext(ctx context.Context) *ListInfraEnvsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list infra envs params
func (o *ListInfraEnvsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list infra envs params
func (o *ListInfraEnvsParams) WithHTTPClient(client *http.Client) *ListInfraEnvsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list infra envs params
func (o *ListInfraEnvsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the list infra envs params
func (o *ListInfraEnvsParams) WithClusterID(clusterID *strfmt.UUID) *ListInfraEnvsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the list infra envs params
func (o *ListInfraEnvsParams) SetClusterID(clusterID *strfmt.UUID) {
	o.ClusterID = clusterID
}

// WriteToRequest writes these params to a swagger request
func (o *ListInfraEnvsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterID != nil {

		// query param cluster_id
		var qrClusterID strfmt.UUID

		if o.ClusterID != nil {
			qrClusterID = *o.ClusterID
		}
		qClusterID := qrClusterID.String()
		if qClusterID != "" {

			if err := r.SetQueryParam("cluster_id", qClusterID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
