// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewResetHostValidationParams creates a new ResetHostValidationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResetHostValidationParams() *ResetHostValidationParams {
	return &ResetHostValidationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResetHostValidationParamsWithTimeout creates a new ResetHostValidationParams object
// with the ability to set a timeout on a request.
func NewResetHostValidationParamsWithTimeout(timeout time.Duration) *ResetHostValidationParams {
	return &ResetHostValidationParams{
		timeout: timeout,
	}
}

// NewResetHostValidationParamsWithContext creates a new ResetHostValidationParams object
// with the ability to set a context for a request.
func NewResetHostValidationParamsWithContext(ctx context.Context) *ResetHostValidationParams {
	return &ResetHostValidationParams{
		Context: ctx,
	}
}

// NewResetHostValidationParamsWithHTTPClient creates a new ResetHostValidationParams object
// with the ability to set a custom HTTPClient for a request.
func NewResetHostValidationParamsWithHTTPClient(client *http.Client) *ResetHostValidationParams {
	return &ResetHostValidationParams{
		HTTPClient: client,
	}
}

/* ResetHostValidationParams contains all the parameters to send to the API endpoint
   for the reset host validation operation.

   Typically these are written to a http.Request.
*/
type ResetHostValidationParams struct {

	/* ClusterID.

	   The cluster of the host that its validation is being reset.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host that its validation is being reset.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* ValidationID.

	   The id of the validation being reset.
	*/
	ValidationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the reset host validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResetHostValidationParams) WithDefaults() *ResetHostValidationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the reset host validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResetHostValidationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the reset host validation params
func (o *ResetHostValidationParams) WithTimeout(timeout time.Duration) *ResetHostValidationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the reset host validation params
func (o *ResetHostValidationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the reset host validation params
func (o *ResetHostValidationParams) WithContext(ctx context.Context) *ResetHostValidationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the reset host validation params
func (o *ResetHostValidationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the reset host validation params
func (o *ResetHostValidationParams) WithHTTPClient(client *http.Client) *ResetHostValidationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the reset host validation params
func (o *ResetHostValidationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the reset host validation params
func (o *ResetHostValidationParams) WithClusterID(clusterID strfmt.UUID) *ResetHostValidationParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the reset host validation params
func (o *ResetHostValidationParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the reset host validation params
func (o *ResetHostValidationParams) WithHostID(hostID strfmt.UUID) *ResetHostValidationParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the reset host validation params
func (o *ResetHostValidationParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithValidationID adds the validationID to the reset host validation params
func (o *ResetHostValidationParams) WithValidationID(validationID string) *ResetHostValidationParams {
	o.SetValidationID(validationID)
	return o
}

// SetValidationID adds the validationId to the reset host validation params
func (o *ResetHostValidationParams) SetValidationID(validationID string) {
	o.ValidationID = validationID
}

// WriteToRequest writes these params to a swagger request
func (o *ResetHostValidationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param validation_id
	if err := r.SetPathParam("validation_id", o.ValidationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
