// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewUpdateHostInstallerArgsParams creates a new UpdateHostInstallerArgsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateHostInstallerArgsParams() *UpdateHostInstallerArgsParams {
	return &UpdateHostInstallerArgsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateHostInstallerArgsParamsWithTimeout creates a new UpdateHostInstallerArgsParams object
// with the ability to set a timeout on a request.
func NewUpdateHostInstallerArgsParamsWithTimeout(timeout time.Duration) *UpdateHostInstallerArgsParams {
	return &UpdateHostInstallerArgsParams{
		timeout: timeout,
	}
}

// NewUpdateHostInstallerArgsParamsWithContext creates a new UpdateHostInstallerArgsParams object
// with the ability to set a context for a request.
func NewUpdateHostInstallerArgsParamsWithContext(ctx context.Context) *UpdateHostInstallerArgsParams {
	return &UpdateHostInstallerArgsParams{
		Context: ctx,
	}
}

// NewUpdateHostInstallerArgsParamsWithHTTPClient creates a new UpdateHostInstallerArgsParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateHostInstallerArgsParamsWithHTTPClient(client *http.Client) *UpdateHostInstallerArgsParams {
	return &UpdateHostInstallerArgsParams{
		HTTPClient: client,
	}
}

/* UpdateHostInstallerArgsParams contains all the parameters to send to the API endpoint
   for the update host installer args operation.

   Typically these are written to a http.Request.
*/
type UpdateHostInstallerArgsParams struct {

	/* ClusterID.

	   The cluster of the host whose installer arguments should be updated.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host whose installer arguments should be updated.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* InstallerArgsParams.

	   The updated installer arguments.
	*/
	InstallerArgsParams *models.InstallerArgsParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update host installer args params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateHostInstallerArgsParams) WithDefaults() *UpdateHostInstallerArgsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update host installer args params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateHostInstallerArgsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithTimeout(timeout time.Duration) *UpdateHostInstallerArgsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithContext(ctx context.Context) *UpdateHostInstallerArgsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithHTTPClient(client *http.Client) *UpdateHostInstallerArgsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithClusterID(clusterID strfmt.UUID) *UpdateHostInstallerArgsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithHostID(hostID strfmt.UUID) *UpdateHostInstallerArgsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInstallerArgsParams adds the installerArgsParams to the update host installer args params
func (o *UpdateHostInstallerArgsParams) WithInstallerArgsParams(installerArgsParams *models.InstallerArgsParams) *UpdateHostInstallerArgsParams {
	o.SetInstallerArgsParams(installerArgsParams)
	return o
}

// SetInstallerArgsParams adds the installerArgsParams to the update host installer args params
func (o *UpdateHostInstallerArgsParams) SetInstallerArgsParams(installerArgsParams *models.InstallerArgsParams) {
	o.InstallerArgsParams = installerArgsParams
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateHostInstallerArgsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}
	if o.InstallerArgsParams != nil {
		if err := r.SetBodyParam(o.InstallerArgsParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
