// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewUploadClusterIngressCertParams creates a new UploadClusterIngressCertParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUploadClusterIngressCertParams() *UploadClusterIngressCertParams {
	return &UploadClusterIngressCertParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUploadClusterIngressCertParamsWithTimeout creates a new UploadClusterIngressCertParams object
// with the ability to set a timeout on a request.
func NewUploadClusterIngressCertParamsWithTimeout(timeout time.Duration) *UploadClusterIngressCertParams {
	return &UploadClusterIngressCertParams{
		timeout: timeout,
	}
}

// NewUploadClusterIngressCertParamsWithContext creates a new UploadClusterIngressCertParams object
// with the ability to set a context for a request.
func NewUploadClusterIngressCertParamsWithContext(ctx context.Context) *UploadClusterIngressCertParams {
	return &UploadClusterIngressCertParams{
		Context: ctx,
	}
}

// NewUploadClusterIngressCertParamsWithHTTPClient creates a new UploadClusterIngressCertParams object
// with the ability to set a custom HTTPClient for a request.
func NewUploadClusterIngressCertParamsWithHTTPClient(client *http.Client) *UploadClusterIngressCertParams {
	return &UploadClusterIngressCertParams{
		HTTPClient: client,
	}
}

/* UploadClusterIngressCertParams contains all the parameters to send to the API endpoint
   for the upload cluster ingress cert operation.

   Typically these are written to a http.Request.
*/
type UploadClusterIngressCertParams struct {

	/* ClusterID.

	   The cluster to associate with the ingress certificate.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is uploading the ingress certificate.
	*/
	DiscoveryAgentVersion *string

	/* IngressCertParams.

	   The ingress certificate.
	*/
	IngressCertParams models.IngressCertParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the upload cluster ingress cert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadClusterIngressCertParams) WithDefaults() *UploadClusterIngressCertParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the upload cluster ingress cert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadClusterIngressCertParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithTimeout(timeout time.Duration) *UploadClusterIngressCertParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithContext(ctx context.Context) *UploadClusterIngressCertParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithHTTPClient(client *http.Client) *UploadClusterIngressCertParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithClusterID(clusterID strfmt.UUID) *UploadClusterIngressCertParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *UploadClusterIngressCertParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithIngressCertParams adds the ingressCertParams to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) WithIngressCertParams(ingressCertParams models.IngressCertParams) *UploadClusterIngressCertParams {
	o.SetIngressCertParams(ingressCertParams)
	return o
}

// SetIngressCertParams adds the ingressCertParams to the upload cluster ingress cert params
func (o *UploadClusterIngressCertParams) SetIngressCertParams(ingressCertParams models.IngressCertParams) {
	o.IngressCertParams = ingressCertParams
}

// WriteToRequest writes these params to a swagger request
func (o *UploadClusterIngressCertParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}
	if err := r.SetBodyParam(o.IngressCertParams); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
