// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUploadLogsParams creates a new UploadLogsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUploadLogsParams() *UploadLogsParams {
	return &UploadLogsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUploadLogsParamsWithTimeout creates a new UploadLogsParams object
// with the ability to set a timeout on a request.
func NewUploadLogsParamsWithTimeout(timeout time.Duration) *UploadLogsParams {
	return &UploadLogsParams{
		timeout: timeout,
	}
}

// NewUploadLogsParamsWithContext creates a new UploadLogsParams object
// with the ability to set a context for a request.
func NewUploadLogsParamsWithContext(ctx context.Context) *UploadLogsParams {
	return &UploadLogsParams{
		Context: ctx,
	}
}

// NewUploadLogsParamsWithHTTPClient creates a new UploadLogsParams object
// with the ability to set a custom HTTPClient for a request.
func NewUploadLogsParamsWithHTTPClient(client *http.Client) *UploadLogsParams {
	return &UploadLogsParams{
		HTTPClient: client,
	}
}

/* UploadLogsParams contains all the parameters to send to the API endpoint
   for the upload logs operation.

   Typically these are written to a http.Request.
*/
type UploadLogsParams struct {

	/* ClusterID.

	   The cluster whose logs should be uploaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* HostID.

	   The host whose logs should be uploaded.

	   Format: uuid
	*/
	HostID *strfmt.UUID

	/* LogsType.

	   The type of log file to be uploaded.
	*/
	LogsType string

	/* Upfile.

	   The log file to be uploaded.
	*/
	Upfile runtime.NamedReadCloser

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the upload logs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadLogsParams) WithDefaults() *UploadLogsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the upload logs params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadLogsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the upload logs params
func (o *UploadLogsParams) WithTimeout(timeout time.Duration) *UploadLogsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the upload logs params
func (o *UploadLogsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the upload logs params
func (o *UploadLogsParams) WithContext(ctx context.Context) *UploadLogsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the upload logs params
func (o *UploadLogsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the upload logs params
func (o *UploadLogsParams) WithHTTPClient(client *http.Client) *UploadLogsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the upload logs params
func (o *UploadLogsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the upload logs params
func (o *UploadLogsParams) WithClusterID(clusterID strfmt.UUID) *UploadLogsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the upload logs params
func (o *UploadLogsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithHostID adds the hostID to the upload logs params
func (o *UploadLogsParams) WithHostID(hostID *strfmt.UUID) *UploadLogsParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the upload logs params
func (o *UploadLogsParams) SetHostID(hostID *strfmt.UUID) {
	o.HostID = hostID
}

// WithLogsType adds the logsType to the upload logs params
func (o *UploadLogsParams) WithLogsType(logsType string) *UploadLogsParams {
	o.SetLogsType(logsType)
	return o
}

// SetLogsType adds the logsType to the upload logs params
func (o *UploadLogsParams) SetLogsType(logsType string) {
	o.LogsType = logsType
}

// WithUpfile adds the upfile to the upload logs params
func (o *UploadLogsParams) WithUpfile(upfile runtime.NamedReadCloser) *UploadLogsParams {
	o.SetUpfile(upfile)
	return o
}

// SetUpfile adds the upfile to the upload logs params
func (o *UploadLogsParams) SetUpfile(upfile runtime.NamedReadCloser) {
	o.Upfile = upfile
}

// WriteToRequest writes these params to a swagger request
func (o *UploadLogsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.HostID != nil {

		// query param host_id
		var qrHostID strfmt.UUID

		if o.HostID != nil {
			qrHostID = *o.HostID
		}
		qHostID := qrHostID.String()
		if qHostID != "" {

			if err := r.SetQueryParam("host_id", qHostID); err != nil {
				return err
			}
		}
	}

	// query param logs_type
	qrLogsType := o.LogsType
	qLogsType := qrLogsType
	if qLogsType != "" {

		if err := r.SetQueryParam("logs_type", qLogsType); err != nil {
			return err
		}
	}

	if o.Upfile != nil {

		if o.Upfile != nil {
			// form file param upfile
			if err := r.SetFileParam("upfile", o.Upfile); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
