// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2CancelInstallationParams creates a new V2CancelInstallationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2CancelInstallationParams() *V2CancelInstallationParams {
	return &V2CancelInstallationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2CancelInstallationParamsWithTimeout creates a new V2CancelInstallationParams object
// with the ability to set a timeout on a request.
func NewV2CancelInstallationParamsWithTimeout(timeout time.Duration) *V2CancelInstallationParams {
	return &V2CancelInstallationParams{
		timeout: timeout,
	}
}

// NewV2CancelInstallationParamsWithContext creates a new V2CancelInstallationParams object
// with the ability to set a context for a request.
func NewV2CancelInstallationParamsWithContext(ctx context.Context) *V2CancelInstallationParams {
	return &V2CancelInstallationParams{
		Context: ctx,
	}
}

// NewV2CancelInstallationParamsWithHTTPClient creates a new V2CancelInstallationParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2CancelInstallationParamsWithHTTPClient(client *http.Client) *V2CancelInstallationParams {
	return &V2CancelInstallationParams{
		HTTPClient: client,
	}
}

/* V2CancelInstallationParams contains all the parameters to send to the API endpoint
   for the v2 cancel installation operation.

   Typically these are written to a http.Request.
*/
type V2CancelInstallationParams struct {

	/* ClusterID.

	   The cluster whose installation is to be canceled.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 cancel installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2CancelInstallationParams) WithDefaults() *V2CancelInstallationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 cancel installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2CancelInstallationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 cancel installation params
func (o *V2CancelInstallationParams) WithTimeout(timeout time.Duration) *V2CancelInstallationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 cancel installation params
func (o *V2CancelInstallationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 cancel installation params
func (o *V2CancelInstallationParams) WithContext(ctx context.Context) *V2CancelInstallationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 cancel installation params
func (o *V2CancelInstallationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 cancel installation params
func (o *V2CancelInstallationParams) WithHTTPClient(client *http.Client) *V2CancelInstallationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 cancel installation params
func (o *V2CancelInstallationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 cancel installation params
func (o *V2CancelInstallationParams) WithClusterID(clusterID strfmt.UUID) *V2CancelInstallationParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 cancel installation params
func (o *V2CancelInstallationParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WriteToRequest writes these params to a swagger request
func (o *V2CancelInstallationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
