// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2CompleteInstallationParams creates a new V2CompleteInstallationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2CompleteInstallationParams() *V2CompleteInstallationParams {
	return &V2CompleteInstallationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2CompleteInstallationParamsWithTimeout creates a new V2CompleteInstallationParams object
// with the ability to set a timeout on a request.
func NewV2CompleteInstallationParamsWithTimeout(timeout time.Duration) *V2CompleteInstallationParams {
	return &V2CompleteInstallationParams{
		timeout: timeout,
	}
}

// NewV2CompleteInstallationParamsWithContext creates a new V2CompleteInstallationParams object
// with the ability to set a context for a request.
func NewV2CompleteInstallationParamsWithContext(ctx context.Context) *V2CompleteInstallationParams {
	return &V2CompleteInstallationParams{
		Context: ctx,
	}
}

// NewV2CompleteInstallationParamsWithHTTPClient creates a new V2CompleteInstallationParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2CompleteInstallationParamsWithHTTPClient(client *http.Client) *V2CompleteInstallationParams {
	return &V2CompleteInstallationParams{
		HTTPClient: client,
	}
}

/* V2CompleteInstallationParams contains all the parameters to send to the API endpoint
   for the v2 complete installation operation.

   Typically these are written to a http.Request.
*/
type V2CompleteInstallationParams struct {

	/* ClusterID.

	   The cluster whose installation is being completing.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* CompletionParams.

	   The final status of the cluster installation.
	*/
	CompletionParams *models.CompletionParams

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is completing the installation.
	*/
	DiscoveryAgentVersion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 complete installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2CompleteInstallationParams) WithDefaults() *V2CompleteInstallationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 complete installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2CompleteInstallationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithTimeout(timeout time.Duration) *V2CompleteInstallationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithContext(ctx context.Context) *V2CompleteInstallationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithHTTPClient(client *http.Client) *V2CompleteInstallationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithClusterID(clusterID strfmt.UUID) *V2CompleteInstallationParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithCompletionParams adds the completionParams to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithCompletionParams(completionParams *models.CompletionParams) *V2CompleteInstallationParams {
	o.SetCompletionParams(completionParams)
	return o
}

// SetCompletionParams adds the completionParams to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetCompletionParams(completionParams *models.CompletionParams) {
	o.CompletionParams = completionParams
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 complete installation params
func (o *V2CompleteInstallationParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *V2CompleteInstallationParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 complete installation params
func (o *V2CompleteInstallationParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WriteToRequest writes these params to a swagger request
func (o *V2CompleteInstallationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}
	if o.CompletionParams != nil {
		if err := r.SetBodyParam(o.CompletionParams); err != nil {
			return err
		}
	}

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
