// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2DownloadClusterCredentialsParams creates a new V2DownloadClusterCredentialsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2DownloadClusterCredentialsParams() *V2DownloadClusterCredentialsParams {
	return &V2DownloadClusterCredentialsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2DownloadClusterCredentialsParamsWithTimeout creates a new V2DownloadClusterCredentialsParams object
// with the ability to set a timeout on a request.
func NewV2DownloadClusterCredentialsParamsWithTimeout(timeout time.Duration) *V2DownloadClusterCredentialsParams {
	return &V2DownloadClusterCredentialsParams{
		timeout: timeout,
	}
}

// NewV2DownloadClusterCredentialsParamsWithContext creates a new V2DownloadClusterCredentialsParams object
// with the ability to set a context for a request.
func NewV2DownloadClusterCredentialsParamsWithContext(ctx context.Context) *V2DownloadClusterCredentialsParams {
	return &V2DownloadClusterCredentialsParams{
		Context: ctx,
	}
}

// NewV2DownloadClusterCredentialsParamsWithHTTPClient creates a new V2DownloadClusterCredentialsParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2DownloadClusterCredentialsParamsWithHTTPClient(client *http.Client) *V2DownloadClusterCredentialsParams {
	return &V2DownloadClusterCredentialsParams{
		HTTPClient: client,
	}
}

/* V2DownloadClusterCredentialsParams contains all the parameters to send to the API endpoint
   for the v2 download cluster credentials operation.

   Typically these are written to a http.Request.
*/
type V2DownloadClusterCredentialsParams struct {

	/* ClusterID.

	   The cluster that owns the credential file that should be downloaded.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* FileName.

	   The credential file to be downloaded.
	*/
	FileName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 download cluster credentials params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2DownloadClusterCredentialsParams) WithDefaults() *V2DownloadClusterCredentialsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 download cluster credentials params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2DownloadClusterCredentialsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) WithTimeout(timeout time.Duration) *V2DownloadClusterCredentialsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) WithContext(ctx context.Context) *V2DownloadClusterCredentialsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) WithHTTPClient(client *http.Client) *V2DownloadClusterCredentialsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) WithClusterID(clusterID strfmt.UUID) *V2DownloadClusterCredentialsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithFileName adds the fileName to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) WithFileName(fileName string) *V2DownloadClusterCredentialsParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the v2 download cluster credentials params
func (o *V2DownloadClusterCredentialsParams) SetFileName(fileName string) {
	o.FileName = fileName
}

// WriteToRequest writes these params to a swagger request
func (o *V2DownloadClusterCredentialsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	// query param file_name
	qrFileName := o.FileName
	qFileName := qrFileName
	if qFileName != "" {

		if err := r.SetQueryParam("file_name", qFileName); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
