// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2GetHostParams creates a new V2GetHostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2GetHostParams() *V2GetHostParams {
	return &V2GetHostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2GetHostParamsWithTimeout creates a new V2GetHostParams object
// with the ability to set a timeout on a request.
func NewV2GetHostParamsWithTimeout(timeout time.Duration) *V2GetHostParams {
	return &V2GetHostParams{
		timeout: timeout,
	}
}

// NewV2GetHostParamsWithContext creates a new V2GetHostParams object
// with the ability to set a context for a request.
func NewV2GetHostParamsWithContext(ctx context.Context) *V2GetHostParams {
	return &V2GetHostParams{
		Context: ctx,
	}
}

// NewV2GetHostParamsWithHTTPClient creates a new V2GetHostParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2GetHostParamsWithHTTPClient(client *http.Client) *V2GetHostParams {
	return &V2GetHostParams{
		HTTPClient: client,
	}
}

/* V2GetHostParams contains all the parameters to send to the API endpoint
   for the v2 get host operation.

   Typically these are written to a http.Request.
*/
type V2GetHostParams struct {

	/* HostID.

	   The host that should be retrieved.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* InfraEnvID.

	   The infra-env of the host that should be retrieved.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 get host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2GetHostParams) WithDefaults() *V2GetHostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 get host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2GetHostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 get host params
func (o *V2GetHostParams) WithTimeout(timeout time.Duration) *V2GetHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 get host params
func (o *V2GetHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 get host params
func (o *V2GetHostParams) WithContext(ctx context.Context) *V2GetHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 get host params
func (o *V2GetHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 get host params
func (o *V2GetHostParams) WithHTTPClient(client *http.Client) *V2GetHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 get host params
func (o *V2GetHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHostID adds the hostID to the v2 get host params
func (o *V2GetHostParams) WithHostID(hostID strfmt.UUID) *V2GetHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 get host params
func (o *V2GetHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 get host params
func (o *V2GetHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2GetHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 get host params
func (o *V2GetHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *V2GetHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
