// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// V2InstallClusterReader is a Reader for the V2InstallCluster structure.
type V2InstallClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *V2InstallClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewV2InstallClusterAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewV2InstallClusterBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewV2InstallClusterUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewV2InstallClusterForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewV2InstallClusterNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewV2InstallClusterMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewV2InstallClusterConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewV2InstallClusterInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewV2InstallClusterAccepted creates a V2InstallClusterAccepted with default headers values
func NewV2InstallClusterAccepted() *V2InstallClusterAccepted {
	return &V2InstallClusterAccepted{}
}

/* V2InstallClusterAccepted describes a response with status code 202, with default header values.

Success.
*/
type V2InstallClusterAccepted struct {
	Payload *models.Cluster
}

func (o *V2InstallClusterAccepted) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterAccepted  %+v", 202, o.Payload)
}
func (o *V2InstallClusterAccepted) GetPayload() *models.Cluster {
	return o.Payload
}

func (o *V2InstallClusterAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Cluster)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterBadRequest creates a V2InstallClusterBadRequest with default headers values
func NewV2InstallClusterBadRequest() *V2InstallClusterBadRequest {
	return &V2InstallClusterBadRequest{}
}

/* V2InstallClusterBadRequest describes a response with status code 400, with default header values.

Error.
*/
type V2InstallClusterBadRequest struct {
	Payload *models.Error
}

func (o *V2InstallClusterBadRequest) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterBadRequest  %+v", 400, o.Payload)
}
func (o *V2InstallClusterBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2InstallClusterBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterUnauthorized creates a V2InstallClusterUnauthorized with default headers values
func NewV2InstallClusterUnauthorized() *V2InstallClusterUnauthorized {
	return &V2InstallClusterUnauthorized{}
}

/* V2InstallClusterUnauthorized describes a response with status code 401, with default header values.

Unauthorized.
*/
type V2InstallClusterUnauthorized struct {
	Payload *models.InfraError
}

func (o *V2InstallClusterUnauthorized) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterUnauthorized  %+v", 401, o.Payload)
}
func (o *V2InstallClusterUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *V2InstallClusterUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterForbidden creates a V2InstallClusterForbidden with default headers values
func NewV2InstallClusterForbidden() *V2InstallClusterForbidden {
	return &V2InstallClusterForbidden{}
}

/* V2InstallClusterForbidden describes a response with status code 403, with default header values.

Forbidden.
*/
type V2InstallClusterForbidden struct {
	Payload *models.InfraError
}

func (o *V2InstallClusterForbidden) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterForbidden  %+v", 403, o.Payload)
}
func (o *V2InstallClusterForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *V2InstallClusterForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterNotFound creates a V2InstallClusterNotFound with default headers values
func NewV2InstallClusterNotFound() *V2InstallClusterNotFound {
	return &V2InstallClusterNotFound{}
}

/* V2InstallClusterNotFound describes a response with status code 404, with default header values.

Error.
*/
type V2InstallClusterNotFound struct {
	Payload *models.Error
}

func (o *V2InstallClusterNotFound) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterNotFound  %+v", 404, o.Payload)
}
func (o *V2InstallClusterNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2InstallClusterNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterMethodNotAllowed creates a V2InstallClusterMethodNotAllowed with default headers values
func NewV2InstallClusterMethodNotAllowed() *V2InstallClusterMethodNotAllowed {
	return &V2InstallClusterMethodNotAllowed{}
}

/* V2InstallClusterMethodNotAllowed describes a response with status code 405, with default header values.

Method Not Allowed.
*/
type V2InstallClusterMethodNotAllowed struct {
	Payload *models.Error
}

func (o *V2InstallClusterMethodNotAllowed) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterMethodNotAllowed  %+v", 405, o.Payload)
}
func (o *V2InstallClusterMethodNotAllowed) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2InstallClusterMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterConflict creates a V2InstallClusterConflict with default headers values
func NewV2InstallClusterConflict() *V2InstallClusterConflict {
	return &V2InstallClusterConflict{}
}

/* V2InstallClusterConflict describes a response with status code 409, with default header values.

Error.
*/
type V2InstallClusterConflict struct {
	Payload *models.Error
}

func (o *V2InstallClusterConflict) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterConflict  %+v", 409, o.Payload)
}
func (o *V2InstallClusterConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2InstallClusterConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewV2InstallClusterInternalServerError creates a V2InstallClusterInternalServerError with default headers values
func NewV2InstallClusterInternalServerError() *V2InstallClusterInternalServerError {
	return &V2InstallClusterInternalServerError{}
}

/* V2InstallClusterInternalServerError describes a response with status code 500, with default header values.

Error.
*/
type V2InstallClusterInternalServerError struct {
	Payload *models.Error
}

func (o *V2InstallClusterInternalServerError) Error() string {
	return fmt.Sprintf("[POST /v2/clusters/{cluster_id}/actions/install][%d] v2InstallClusterInternalServerError  %+v", 500, o.Payload)
}
func (o *V2InstallClusterInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *V2InstallClusterInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
