// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2RegisterHostParams creates a new V2RegisterHostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2RegisterHostParams() *V2RegisterHostParams {
	return &V2RegisterHostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2RegisterHostParamsWithTimeout creates a new V2RegisterHostParams object
// with the ability to set a timeout on a request.
func NewV2RegisterHostParamsWithTimeout(timeout time.Duration) *V2RegisterHostParams {
	return &V2RegisterHostParams{
		timeout: timeout,
	}
}

// NewV2RegisterHostParamsWithContext creates a new V2RegisterHostParams object
// with the ability to set a context for a request.
func NewV2RegisterHostParamsWithContext(ctx context.Context) *V2RegisterHostParams {
	return &V2RegisterHostParams{
		Context: ctx,
	}
}

// NewV2RegisterHostParamsWithHTTPClient creates a new V2RegisterHostParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2RegisterHostParamsWithHTTPClient(client *http.Client) *V2RegisterHostParams {
	return &V2RegisterHostParams{
		HTTPClient: client,
	}
}

/* V2RegisterHostParams contains all the parameters to send to the API endpoint
   for the v2 register host operation.

   Typically these are written to a http.Request.
*/
type V2RegisterHostParams struct {

	/* DiscoveryAgentVersion.

	   The software version of the discovery agent that is registering the agent.
	*/
	DiscoveryAgentVersion *string

	/* InfraEnvID.

	   The infra-env that the agent is associated with.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	/* NewHostParams.

	   The description of the agent being registered.
	*/
	NewHostParams *models.HostCreateParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 register host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2RegisterHostParams) WithDefaults() *V2RegisterHostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 register host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2RegisterHostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 register host params
func (o *V2RegisterHostParams) WithTimeout(timeout time.Duration) *V2RegisterHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 register host params
func (o *V2RegisterHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 register host params
func (o *V2RegisterHostParams) WithContext(ctx context.Context) *V2RegisterHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 register host params
func (o *V2RegisterHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 register host params
func (o *V2RegisterHostParams) WithHTTPClient(client *http.Client) *V2RegisterHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 register host params
func (o *V2RegisterHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 register host params
func (o *V2RegisterHostParams) WithDiscoveryAgentVersion(discoveryAgentVersion *string) *V2RegisterHostParams {
	o.SetDiscoveryAgentVersion(discoveryAgentVersion)
	return o
}

// SetDiscoveryAgentVersion adds the discoveryAgentVersion to the v2 register host params
func (o *V2RegisterHostParams) SetDiscoveryAgentVersion(discoveryAgentVersion *string) {
	o.DiscoveryAgentVersion = discoveryAgentVersion
}

// WithInfraEnvID adds the infraEnvID to the v2 register host params
func (o *V2RegisterHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2RegisterHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 register host params
func (o *V2RegisterHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WithNewHostParams adds the newHostParams to the v2 register host params
func (o *V2RegisterHostParams) WithNewHostParams(newHostParams *models.HostCreateParams) *V2RegisterHostParams {
	o.SetNewHostParams(newHostParams)
	return o
}

// SetNewHostParams adds the newHostParams to the v2 register host params
func (o *V2RegisterHostParams) SetNewHostParams(newHostParams *models.HostCreateParams) {
	o.NewHostParams = newHostParams
}

// WriteToRequest writes these params to a swagger request
func (o *V2RegisterHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DiscoveryAgentVersion != nil {

		// header param discovery_agent_version
		if err := r.SetHeaderParam("discovery_agent_version", *o.DiscoveryAgentVersion); err != nil {
			return err
		}
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}
	if o.NewHostParams != nil {
		if err := r.SetBodyParam(o.NewHostParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
