// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewV2ResetHostParams creates a new V2ResetHostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2ResetHostParams() *V2ResetHostParams {
	return &V2ResetHostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2ResetHostParamsWithTimeout creates a new V2ResetHostParams object
// with the ability to set a timeout on a request.
func NewV2ResetHostParamsWithTimeout(timeout time.Duration) *V2ResetHostParams {
	return &V2ResetHostParams{
		timeout: timeout,
	}
}

// NewV2ResetHostParamsWithContext creates a new V2ResetHostParams object
// with the ability to set a context for a request.
func NewV2ResetHostParamsWithContext(ctx context.Context) *V2ResetHostParams {
	return &V2ResetHostParams{
		Context: ctx,
	}
}

// NewV2ResetHostParamsWithHTTPClient creates a new V2ResetHostParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2ResetHostParamsWithHTTPClient(client *http.Client) *V2ResetHostParams {
	return &V2ResetHostParams{
		HTTPClient: client,
	}
}

/* V2ResetHostParams contains all the parameters to send to the API endpoint
   for the v2 reset host operation.

   Typically these are written to a http.Request.
*/
type V2ResetHostParams struct {

	/* HostID.

	   The host that is being reset.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* InfraEnvID.

	   The infra-env of the host that is being reset.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 reset host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ResetHostParams) WithDefaults() *V2ResetHostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 reset host params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ResetHostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 reset host params
func (o *V2ResetHostParams) WithTimeout(timeout time.Duration) *V2ResetHostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 reset host params
func (o *V2ResetHostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 reset host params
func (o *V2ResetHostParams) WithContext(ctx context.Context) *V2ResetHostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 reset host params
func (o *V2ResetHostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 reset host params
func (o *V2ResetHostParams) WithHTTPClient(client *http.Client) *V2ResetHostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 reset host params
func (o *V2ResetHostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHostID adds the hostID to the v2 reset host params
func (o *V2ResetHostParams) WithHostID(hostID strfmt.UUID) *V2ResetHostParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 reset host params
func (o *V2ResetHostParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 reset host params
func (o *V2ResetHostParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2ResetHostParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 reset host params
func (o *V2ResetHostParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WriteToRequest writes these params to a swagger request
func (o *V2ResetHostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
