// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2UpdateHostLogsProgressParams creates a new V2UpdateHostLogsProgressParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2UpdateHostLogsProgressParams() *V2UpdateHostLogsProgressParams {
	return &V2UpdateHostLogsProgressParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2UpdateHostLogsProgressParamsWithTimeout creates a new V2UpdateHostLogsProgressParams object
// with the ability to set a timeout on a request.
func NewV2UpdateHostLogsProgressParamsWithTimeout(timeout time.Duration) *V2UpdateHostLogsProgressParams {
	return &V2UpdateHostLogsProgressParams{
		timeout: timeout,
	}
}

// NewV2UpdateHostLogsProgressParamsWithContext creates a new V2UpdateHostLogsProgressParams object
// with the ability to set a context for a request.
func NewV2UpdateHostLogsProgressParamsWithContext(ctx context.Context) *V2UpdateHostLogsProgressParams {
	return &V2UpdateHostLogsProgressParams{
		Context: ctx,
	}
}

// NewV2UpdateHostLogsProgressParamsWithHTTPClient creates a new V2UpdateHostLogsProgressParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2UpdateHostLogsProgressParamsWithHTTPClient(client *http.Client) *V2UpdateHostLogsProgressParams {
	return &V2UpdateHostLogsProgressParams{
		HTTPClient: client,
	}
}

/* V2UpdateHostLogsProgressParams contains all the parameters to send to the API endpoint
   for the v2 update host logs progress operation.

   Typically these are written to a http.Request.
*/
type V2UpdateHostLogsProgressParams struct {

	/* HostID.

	   The host whose log progress is being updated.

	   Format: uuid
	*/
	HostID strfmt.UUID

	/* InfraEnvID.

	   The infra-env whose log progress is being updated.

	   Format: uuid
	*/
	InfraEnvID strfmt.UUID

	/* LogsProgressParams.

	   Parameters for updating log progress.
	*/
	LogsProgressParams *models.LogsProgressParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 update host logs progress params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2UpdateHostLogsProgressParams) WithDefaults() *V2UpdateHostLogsProgressParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 update host logs progress params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2UpdateHostLogsProgressParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithTimeout(timeout time.Duration) *V2UpdateHostLogsProgressParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithContext(ctx context.Context) *V2UpdateHostLogsProgressParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithHTTPClient(client *http.Client) *V2UpdateHostLogsProgressParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHostID adds the hostID to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithHostID(hostID strfmt.UUID) *V2UpdateHostLogsProgressParams {
	o.SetHostID(hostID)
	return o
}

// SetHostID adds the hostId to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetHostID(hostID strfmt.UUID) {
	o.HostID = hostID
}

// WithInfraEnvID adds the infraEnvID to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithInfraEnvID(infraEnvID strfmt.UUID) *V2UpdateHostLogsProgressParams {
	o.SetInfraEnvID(infraEnvID)
	return o
}

// SetInfraEnvID adds the infraEnvId to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetInfraEnvID(infraEnvID strfmt.UUID) {
	o.InfraEnvID = infraEnvID
}

// WithLogsProgressParams adds the logsProgressParams to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) WithLogsProgressParams(logsProgressParams *models.LogsProgressParams) *V2UpdateHostLogsProgressParams {
	o.SetLogsProgressParams(logsProgressParams)
	return o
}

// SetLogsProgressParams adds the logsProgressParams to the v2 update host logs progress params
func (o *V2UpdateHostLogsProgressParams) SetLogsProgressParams(logsProgressParams *models.LogsProgressParams) {
	o.LogsProgressParams = logsProgressParams
}

// WriteToRequest writes these params to a swagger request
func (o *V2UpdateHostLogsProgressParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host_id
	if err := r.SetPathParam("host_id", o.HostID.String()); err != nil {
		return err
	}

	// path param infra_env_id
	if err := r.SetPathParam("infra_env_id", o.InfraEnvID.String()); err != nil {
		return err
	}
	if o.LogsProgressParams != nil {
		if err := r.SetBodyParam(o.LogsProgressParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
