// Code generated by go-swagger; DO NOT EDIT.

package operators

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewV2ReportMonitoredOperatorStatusParams creates a new V2ReportMonitoredOperatorStatusParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewV2ReportMonitoredOperatorStatusParams() *V2ReportMonitoredOperatorStatusParams {
	return &V2ReportMonitoredOperatorStatusParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewV2ReportMonitoredOperatorStatusParamsWithTimeout creates a new V2ReportMonitoredOperatorStatusParams object
// with the ability to set a timeout on a request.
func NewV2ReportMonitoredOperatorStatusParamsWithTimeout(timeout time.Duration) *V2ReportMonitoredOperatorStatusParams {
	return &V2ReportMonitoredOperatorStatusParams{
		timeout: timeout,
	}
}

// NewV2ReportMonitoredOperatorStatusParamsWithContext creates a new V2ReportMonitoredOperatorStatusParams object
// with the ability to set a context for a request.
func NewV2ReportMonitoredOperatorStatusParamsWithContext(ctx context.Context) *V2ReportMonitoredOperatorStatusParams {
	return &V2ReportMonitoredOperatorStatusParams{
		Context: ctx,
	}
}

// NewV2ReportMonitoredOperatorStatusParamsWithHTTPClient creates a new V2ReportMonitoredOperatorStatusParams object
// with the ability to set a custom HTTPClient for a request.
func NewV2ReportMonitoredOperatorStatusParamsWithHTTPClient(client *http.Client) *V2ReportMonitoredOperatorStatusParams {
	return &V2ReportMonitoredOperatorStatusParams{
		HTTPClient: client,
	}
}

/* V2ReportMonitoredOperatorStatusParams contains all the parameters to send to the API endpoint
   for the v2 report monitored operator status operation.

   Typically these are written to a http.Request.
*/
type V2ReportMonitoredOperatorStatusParams struct {

	/* ClusterID.

	   The cluster whose operators are being monitored.

	   Format: uuid
	*/
	ClusterID strfmt.UUID

	/* ReportParams.

	   The operators monitor report.
	*/
	ReportParams *models.OperatorMonitorReport

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the v2 report monitored operator status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ReportMonitoredOperatorStatusParams) WithDefaults() *V2ReportMonitoredOperatorStatusParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the v2 report monitored operator status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *V2ReportMonitoredOperatorStatusParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) WithTimeout(timeout time.Duration) *V2ReportMonitoredOperatorStatusParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) WithContext(ctx context.Context) *V2ReportMonitoredOperatorStatusParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) WithHTTPClient(client *http.Client) *V2ReportMonitoredOperatorStatusParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) WithClusterID(clusterID strfmt.UUID) *V2ReportMonitoredOperatorStatusParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithReportParams adds the reportParams to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) WithReportParams(reportParams *models.OperatorMonitorReport) *V2ReportMonitoredOperatorStatusParams {
	o.SetReportParams(reportParams)
	return o
}

// SetReportParams adds the reportParams to the v2 report monitored operator status params
func (o *V2ReportMonitoredOperatorStatusParams) SetReportParams(reportParams *models.OperatorMonitorReport) {
	o.ReportParams = reportParams
}

// WriteToRequest writes these params to a swagger request
func (o *V2ReportMonitoredOperatorStatusParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}
	if o.ReportParams != nil {
		if err := r.SetBodyParam(o.ReportParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
