// Code generated by go-swagger; DO NOT EDIT.

package versions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

//go:generate mockery -name API -inpkg

// API is the interface of the versions client
type API interface {
	/*
	   ListComponentVersions List of component versions.*/
	ListComponentVersions(ctx context.Context, params *ListComponentVersionsParams) (*ListComponentVersionsOK, error)
	/*
	   ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions.*/
	ListSupportedOpenshiftVersions(ctx context.Context, params *ListSupportedOpenshiftVersionsParams) (*ListSupportedOpenshiftVersionsOK, error)
	/*
	   V2ListComponentVersions List of component versions.*/
	V2ListComponentVersions(ctx context.Context, params *V2ListComponentVersionsParams) (*V2ListComponentVersionsOK, error)
	/*
	   V2ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions.*/
	V2ListSupportedOpenshiftVersions(ctx context.Context, params *V2ListSupportedOpenshiftVersionsParams) (*V2ListSupportedOpenshiftVersionsOK, error)
}

// New creates a new versions API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry, authInfo runtime.ClientAuthInfoWriter) *Client {
	return &Client{
		transport: transport,
		formats:   formats,
		authInfo:  authInfo,
	}
}

/*
Client for versions API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
	authInfo  runtime.ClientAuthInfoWriter
}

/*
ListComponentVersions List of component versions.
*/
func (a *Client) ListComponentVersions(ctx context.Context, params *ListComponentVersionsParams) (*ListComponentVersionsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListComponentVersions",
		Method:             "GET",
		PathPattern:        "/v1/component_versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListComponentVersionsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListComponentVersionsOK), nil

}

/*
ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions.
*/
func (a *Client) ListSupportedOpenshiftVersions(ctx context.Context, params *ListSupportedOpenshiftVersionsParams) (*ListSupportedOpenshiftVersionsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListSupportedOpenshiftVersions",
		Method:             "GET",
		PathPattern:        "/v1/openshift_versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListSupportedOpenshiftVersionsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListSupportedOpenshiftVersionsOK), nil

}

/*
V2ListComponentVersions List of component versions.
*/
func (a *Client) V2ListComponentVersions(ctx context.Context, params *V2ListComponentVersionsParams) (*V2ListComponentVersionsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListComponentVersions",
		Method:             "GET",
		PathPattern:        "/v2/component-versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListComponentVersionsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListComponentVersionsOK), nil

}

/*
V2ListSupportedOpenshiftVersions Retrieves the list of OpenShift supported versions.
*/
func (a *Client) V2ListSupportedOpenshiftVersions(ctx context.Context, params *V2ListSupportedOpenshiftVersionsParams) (*V2ListSupportedOpenshiftVersionsOK, error) {

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "v2ListSupportedOpenshiftVersions",
		Method:             "GET",
		PathPattern:        "/v2/openshift-versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &V2ListSupportedOpenshiftVersionsReader{formats: a.formats},
		AuthInfo:           a.authInfo,
		Context:            ctx,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*V2ListSupportedOpenshiftVersionsOK), nil

}
