// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIVipConnectivityRequest api vip connectivity request
//
// swagger:model api_vip_connectivity_request
type APIVipConnectivityRequest struct {

	// A CA certficate to be used when contacting the URL via https.
	CaCertificate *string `json:"ca_certificate,omitempty"`

	// A string which will be used as Authorization Bearer token to fetch the ignition from ignition_endpoint_url.
	IgnitionEndpointToken *string `json:"ignition_endpoint_token,omitempty"`

	// URL address of the API.
	// Required: true
	URL *string `json:"url"`

	// Whether to verify if the API VIP belongs to one of the interfaces (DEPRECATED).
	VerifyCidr bool `json:"verify_cidr,omitempty"`
}

// Validate validates this api vip connectivity request
func (m *APIVipConnectivityRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateURL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIVipConnectivityRequest) validateURL(formats strfmt.Registry) error {

	if err := validate.Required("url", "body", m.URL); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this api vip connectivity request based on context it is used
func (m *APIVipConnectivityRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *APIVipConnectivityRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIVipConnectivityRequest) UnmarshalBinary(b []byte) error {
	var res APIVipConnectivityRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
