// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostCreateParams host create params
//
// swagger:model host-create-params
type HostCreateParams struct {

	// discovery agent version
	DiscoveryAgentVersion string `json:"discovery_agent_version,omitempty"`

	// host id
	// Required: true
	// Format: uuid
	HostID *strfmt.UUID `json:"host_id"`
}

// Validate validates this host create params
func (m *HostCreateParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostCreateParams) validateHostID(formats strfmt.Registry) error {

	if err := validate.Required("host_id", "body", m.HostID); err != nil {
		return err
	}

	if err := validate.FormatOf("host_id", "body", "uuid", m.HostID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this host create params based on context it is used
func (m *HostCreateParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HostCreateParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostCreateParams) UnmarshalBinary(b []byte) error {
	var res HostCreateParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
