// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HostRegistrationResponse host registration response
//
// swagger:model host_registration_response
type HostRegistrationResponse struct {
	Host

	// next step runner command
	NextStepRunnerCommand *HostRegistrationResponseAO1NextStepRunnerCommand `json:"next_step_runner_command,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *HostRegistrationResponse) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 Host
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.Host = aO0

	// AO1
	var dataAO1 struct {
		NextStepRunnerCommand *HostRegistrationResponseAO1NextStepRunnerCommand `json:"next_step_runner_command,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.NextStepRunnerCommand = dataAO1.NextStepRunnerCommand

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m HostRegistrationResponse) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.Host)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		NextStepRunnerCommand *HostRegistrationResponseAO1NextStepRunnerCommand `json:"next_step_runner_command,omitempty"`
	}

	dataAO1.NextStepRunnerCommand = m.NextStepRunnerCommand

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this host registration response
func (m *HostRegistrationResponse) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with Host
	if err := m.Host.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNextStepRunnerCommand(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostRegistrationResponse) validateNextStepRunnerCommand(formats strfmt.Registry) error {

	if swag.IsZero(m.NextStepRunnerCommand) { // not required
		return nil
	}

	if m.NextStepRunnerCommand != nil {
		if err := m.NextStepRunnerCommand.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("next_step_runner_command")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("next_step_runner_command")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this host registration response based on the context it is used
func (m *HostRegistrationResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with Host
	if err := m.Host.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNextStepRunnerCommand(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostRegistrationResponse) contextValidateNextStepRunnerCommand(ctx context.Context, formats strfmt.Registry) error {

	if m.NextStepRunnerCommand != nil {
		if err := m.NextStepRunnerCommand.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("next_step_runner_command")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("next_step_runner_command")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostRegistrationResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostRegistrationResponse) UnmarshalBinary(b []byte) error {
	var res HostRegistrationResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HostRegistrationResponseAO1NextStepRunnerCommand Command for starting the next step runner
//
// swagger:model HostRegistrationResponseAO1NextStepRunnerCommand
type HostRegistrationResponseAO1NextStepRunnerCommand struct {

	// args
	Args []string `json:"args"`

	// command
	Command string `json:"command,omitempty"`

	// How long in seconds to wait before retrying registration if the command fails
	RetrySeconds int64 `json:"retry_seconds,omitempty"`
}

// Validate validates this host registration response a o1 next step runner command
func (m *HostRegistrationResponseAO1NextStepRunnerCommand) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this host registration response a o1 next step runner command based on context it is used
func (m *HostRegistrationResponseAO1NextStepRunnerCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HostRegistrationResponseAO1NextStepRunnerCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostRegistrationResponseAO1NextStepRunnerCommand) UnmarshalBinary(b []byte) error {
	var res HostRegistrationResponseAO1NextStepRunnerCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
