// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Manifest manifest
//
// swagger:model manifest
type Manifest struct {

	// The file name prefaced by the folder that contains it.
	FileName string `json:"file_name,omitempty"`

	// The folder that contains the files. Manifests can be placed in 'manifests' or 'openshift' directories.
	// Enum: [manifests openshift]
	Folder string `json:"folder,omitempty"`
}

// Validate validates this manifest
func (m *Manifest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFolder(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var manifestTypeFolderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["manifests","openshift"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		manifestTypeFolderPropEnum = append(manifestTypeFolderPropEnum, v)
	}
}

const (

	// ManifestFolderManifests captures enum value "manifests"
	ManifestFolderManifests string = "manifests"

	// ManifestFolderOpenshift captures enum value "openshift"
	ManifestFolderOpenshift string = "openshift"
)

// prop value enum
func (m *Manifest) validateFolderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, manifestTypeFolderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Manifest) validateFolder(formats strfmt.Registry) error {
	if swag.IsZero(m.Folder) { // not required
		return nil
	}

	// value enum
	if err := m.validateFolderEnum("folder", "body", m.Folder); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this manifest based on context it is used
func (m *Manifest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Manifest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Manifest) UnmarshalBinary(b []byte) error {
	var res Manifest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
